/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.item;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.command.CommandDev;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ItemBlockArmor;
import twopiradians.blockArmor.common.seteffect.SetEffect;
import twopiradians.blockArmor.creativetab.BlockArmorCreativeTab;

public class ArmorSet {
    private static final ArrayList<ItemStack> MANUALLY_ADDED_SETS = new ArrayList<ItemStack>(){
        {
            this.add(new ItemStack(Items.field_151120_aE));
            this.add(new ItemStack((Block)Blocks.field_150434_aF));
            this.add(new ItemStack(Blocks.field_150433_aE));
            this.add(new ItemStack(Blocks.field_150367_z));
            this.add(new ItemStack(Blocks.field_150409_cd));
            this.add(new ItemStack((Block)Blocks.field_150461_bJ));
            this.add(new ItemStack(Blocks.field_150460_al));
            this.add(new ItemStack(Blocks.field_150381_bn));
            this.add(new ItemStack(Blocks.field_150483_bI));
            this.add(new ItemStack(Blocks.field_185777_dd));
            this.add(new ItemStack(Blocks.field_185776_dc));
            this.add(new ItemStack(Blocks.field_150420_aW));
            this.add(new ItemStack(Blocks.field_150419_aX));
            this.add(new ItemStack(Blocks.field_150425_aM));
            this.add(new ItemStack(Blocks.field_150477_bB));
            this.add(new ItemStack(Blocks.field_150323_B));
        }
    };
    public static final ArrayList<Item> TEXTURE_OVERRIDES = new ArrayList<Item>(){
        {
            this.add(Items.field_151120_aE);
            this.add(Item.func_150898_a((Block)Blocks.field_150477_bB));
        }
    };
    public static ArrayList<ArmorSet> allSets;
    public static HashMap<String, ArmorSet> nameToSetMap;
    public static final EntityEquipmentSlot[] SLOTS;
    public ItemStack stack;
    public Item item;
    public int meta;
    public Block block;
    public ItemArmor.ArmorMaterial material;
    public ItemBlockArmor helmet;
    public ItemBlockArmor chestplate;
    public ItemBlockArmor leggings;
    public ItemBlockArmor boots;
    public boolean isFromModdedBlock;
    public ArrayList<SetEffect> setEffects;
    public String modid;
    private boolean enabled;
    public ArrayList<IRecipe> recipes;
    public boolean missingTextures;
    @SideOnly(value=Side.CLIENT)
    public boolean isTranslucent;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] sprites;
    @SideOnly(value=Side.CLIENT)
    public AnimationMetadataSection[] animations;
    @SideOnly(value=Side.CLIENT)
    public float[] frames;
    @SideOnly(value=Side.CLIENT)
    private int[] colors;
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite missingSprite;

    public ArmorSet(ItemStack stack) {
        this.stack = stack;
        this.item = stack.func_77973_b();
        try {
            ResourceLocation loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item);
            if (!loc.func_110624_b().equals("minecraft")) {
                this.isFromModdedBlock = true;
            }
            this.modid = loc.func_110624_b().toLowerCase();
        }
        catch (Exception e) {
            this.modid = "???";
            this.isFromModdedBlock = true;
        }
        this.meta = stack.func_77960_j();
        this.block = this.item == Items.field_151120_aE ? Blocks.field_150436_aH : ((ItemBlock)this.item).func_179223_d();
        float blockHardness = 0.0f;
        double durability = 5.0;
        float toughness = 0.0f;
        int enchantability = 12;
        try {
            blockHardness = this.block.func_176195_g(this.block.func_176223_P(), null, new BlockPos(0, 0, 0));
        }
        catch (Exception e) {
            blockHardness = ((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)this.block, (int)11)).floatValue();
        }
        if (blockHardness == -1.0f) {
            durability = 0.0;
            blockHardness = 1000.0f;
        } else {
            durability = 2.0 + 8.0 * Math.log(blockHardness + 1.0f);
        }
        if (blockHardness > 10.0f) {
            toughness = Math.min(blockHardness / 10.0f, 10.0f);
        }
        durability = Math.min(30.0, durability);
        int reductionHelmetBoots = (int)((Math.min(Math.floor(Math.log10(Math.pow(blockHardness, 2.0) + 1.0) + 1.6), 3.0) + 4.0) / 2.0 - 1.0 + (double)Math.min(blockHardness, 1.0f));
        int reductionChest = (int)((Math.min(blockHardness + 1.0f, 8.0f) + 4.0f) / 2.0f - 1.0f + Math.min(blockHardness, 1.0f));
        int reductionLegs = (int)((float)((Math.max(reductionChest - 2, reductionHelmetBoots) + 4) / 2 - 1) + Math.min(blockHardness, 1.0f));
        int[] reductionAmounts = new int[]{reductionHelmetBoots, reductionLegs, reductionChest, reductionHelmetBoots};
        this.material = EnumHelper.addArmorMaterial((String)(ArmorSet.getItemStackDisplayName(stack, null) + " Material"), (String)"", (int)((int)durability), (int[])reductionAmounts, (int)enchantability, (SoundEvent)SoundEvents.field_187719_p, (float)toughness);
        this.material.customCraftingMaterial = this.item;
        CommandDev.addBlockName(this);
    }

    public ItemBlockArmor getArmorForSlot(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return this.helmet;
            }
            case CHEST: {
                return this.chestplate;
            }
            case LEGS: {
                return this.leggings;
            }
            case FEET: {
                return this.boots;
            }
        }
        return null;
    }

    public static void postInit() {
        ArrayList<String> displayNames = new ArrayList<String>();
        Block[] blocks = (Block[])Iterators.toArray((Iterator)Block.field_149771_c.iterator(), Block.class);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        block2: for (Block block : blocks) {
            for (int i = 0; i < 16; ++i) {
                try {
                    ItemStack stack = block == Blocks.field_150436_aH ? new ItemStack(Items.field_151120_aE, 1, i) : new ItemStack(block, 1, i);
                    boolean manuallyAdded = false;
                    for (ItemStack manualStack : MANUALLY_ADDED_SETS) {
                        if (stack == null || stack.func_77973_b() != manualStack.func_77973_b() || stack.func_77960_j() != manualStack.func_77960_j()) continue;
                        manuallyAdded = true;
                    }
                    if (block.equals(Blocks.field_150364_r) && i > 3) continue block2;
                    if (!manuallyAdded && (stack == null || stack.func_77973_b() == null || stack.func_82833_r().equals("") || displayNames.contains(stack.func_82833_r()))) continue;
                    stacks.add(stack);
                    displayNames.add(stack.func_82833_r());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        ArrayList<String> registryNames = new ArrayList<String>();
        allSets = new ArrayList();
        nameToSetMap = Maps.newHashMap();
        for (ItemStack stack : stacks) {
            String registryName;
            if (!ArmorSet.isValid(stack) || ArmorSet.getSet(stack.func_77973_b(), stack.func_77960_j()) != null || registryNames.contains(registryName = ArmorSet.getItemStackRegistryName(stack)) || registryName.equals("")) continue;
            ArmorSet set = new ArmorSet(stack);
            allSets.add(set);
            nameToSetMap.put(registryName, set);
            registryNames.add(registryName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(ItemBlockArmor item) {
        if (item != null) {
            TextureAtlasSprite sprite = item.set.sprites[item.field_77881_a.func_188454_b()];
            return sprite == null ? missingSprite : sprite;
        }
        return missingSprite;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getAlpha(ItemBlockArmor item) {
        if (item != null) {
            float frame = item.set.frames[item.field_77881_a.func_188454_b()];
            return frame - (float)((int)frame);
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getCurrentAnimationFrame(ItemBlockArmor item) {
        AnimationMetadataSection animation;
        if (item != null && (animation = item.set.animations[item.field_77881_a.func_188454_b()]) != null) {
            int frame = (int)item.set.frames[item.field_77881_a.func_188454_b()];
            return animation.func_110468_c(frame);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getNextAnimationFrame(ItemBlockArmor item) {
        AnimationMetadataSection animation;
        if (item != null && (animation = item.set.animations[item.field_77881_a.func_188454_b()]) != null) {
            int frame = (int)item.set.frames[item.field_77881_a.func_188454_b()];
            if (frame++ >= animation.func_110473_c() - 1) {
                frame -= animation.func_110473_c();
            }
            return animation.func_110468_c(frame);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColor(ItemBlockArmor item) {
        if (item != null) {
            return item.set.colors[item.field_77881_a.func_188454_b()];
        }
        return -1;
    }

    public static String getItemStackRegistryName(ItemStack stack) {
        try {
            String registryName = stack.func_77973_b().getRegistryName().func_110623_a().toLowerCase().replace(" ", "_");
            registryName = registryName + (stack.func_77981_g() ? "_" + stack.func_77960_j() : "");
            return registryName;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getItemStackDisplayName(ItemStack stack, EntityEquipmentSlot slot) {
        String name = stack != null && stack.func_77973_b() instanceof ItemBlockArmor ? ((ItemBlockArmor)stack.func_77973_b()).set.stack.func_82833_r() : (stack != null && stack.func_77973_b() != null ? stack.func_82833_r() : "");
        name = name.replace("Block of ", "").replace("Block ", "").replace(" Block", "").replace("Sugar Canes", "Sugar Cane").replace("Bricks", "Brick").replace("Planks", "Plank");
        name = TextFormatting.func_110646_a((String)name);
        if (slot != null) {
            switch (slot) {
                case HEAD: {
                    name = name + " Helmet";
                    break;
                }
                case CHEST: {
                    name = name + " Chestplate";
                    break;
                }
                case LEGS: {
                    name = name + " Leggings";
                    break;
                }
                case FEET: {
                    name = name + " Boots";
                    break;
                }
            }
        }
        return name;
    }

    public static ItemStack getFirstSetItem(EntityLivingBase entity, SetEffect effect) {
        if (effect != null && ArmorSet.getWornSetEffects(entity).contains(effect)) {
            for (EntityEquipmentSlot slot : SLOTS) {
                ItemStack stack = entity.func_184582_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof ItemBlockArmor) || !((ItemBlockArmor)stack.func_77973_b()).set.setEffects.contains(effect)) continue;
                return stack;
            }
        }
        return null;
    }

    public static ArrayList<SetEffect> getWornSetEffects(EntityLivingBase entity) {
        ArrayList<SetEffect> effects = new ArrayList<SetEffect>();
        HashMap setCounts = Maps.newHashMap();
        if (entity != null) {
            for (EntityEquipmentSlot slot : SLOTS) {
                ItemStack stack = entity.func_184582_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof ItemBlockArmor)) continue;
                ItemBlockArmor armor = (ItemBlockArmor)stack.func_77973_b();
                for (SetEffect effect : armor.set.setEffects) {
                    if (!effect.isEnabled()) continue;
                    Tuple t = null;
                    for (String description : setCounts.keySet()) {
                        if (!description.equals(effect.description)) continue;
                        t = (Tuple)setCounts.get(effect.description);
                    }
                    if (t != null) {
                        setCounts.put(effect.description, new Tuple(t.func_76341_a(), (Object)((Integer)t.func_76340_b() + 1)));
                        continue;
                    }
                    setCounts.put(effect.description, new Tuple((Object)effect, (Object)1));
                }
            }
            for (String description : setCounts.keySet()) {
                if ((Integer)((Tuple)setCounts.get(description)).func_76340_b() < Config.piecesForSet) continue;
                effects.add((SetEffect)((Tuple)setCounts.get(description)).func_76341_a());
            }
        }
        return effects;
    }

    public static ArmorSet getSet(Block block, int meta) {
        for (ArmorSet set : allSets) {
            if (set.block != block || set.meta != meta) continue;
            return set;
        }
        return null;
    }

    public static ArmorSet getSet(Item item, int meta) {
        for (ArmorSet set : allSets) {
            if (set.item != item || set.meta != meta) continue;
            return set;
        }
        return null;
    }

    private static boolean isValid(ItemStack stack) {
        try {
            for (ItemStack manualStack : MANUALLY_ADDED_SETS) {
                if (stack == null || stack.func_77973_b() != manualStack.func_77973_b() || stack.func_77960_j() != manualStack.func_77960_j()) continue;
                return true;
            }
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock) || stack.func_77973_b().getRegistryName().func_110624_b().contains("one_point_twelve_concrete") || stack.func_77973_b().getRegistryName().func_110624_b().contains("railcraft") || stack.func_77973_b().getRegistryName().func_110623_a().contains("ore") || stack.func_77973_b().getRegistryName().func_110623_a().contains("ingot") || stack.func_82833_r().contains(".name") || stack.func_82833_r().contains("Ore") || stack.func_82833_r().contains("%") || stack.func_82833_r().contains("Ingot")) {
                return false;
            }
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            if (block instanceof BlockLiquid || block instanceof BlockContainer || block.func_149716_u() || block instanceof BlockOre || block instanceof BlockCrops || block instanceof BlockBush || block == Blocks.field_180401_cv || block instanceof BlockSlab || block == Blocks.field_150418_aU || block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.MODEL || block == Blocks.field_150339_S || block == Blocks.field_150340_R || block == Blocks.field_150484_ah) {
                return false;
            }
            String registryName = block.getRegistryName().toString();
            if (registryName.equalsIgnoreCase("evilcraft:darkBlock") || registryName.equalsIgnoreCase("evilcraft:obscuredGlass") || registryName.equalsIgnoreCase("evilcraft:hardenedBlood") || registryName.equalsIgnoreCase("evilcraft:darkPowerGemBlock") || registryName.equalsIgnoreCase("darkutils:filter") || registryName.equalsIgnoreCase("darkutils:filter_inverted") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedanalyser") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedbot") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedmutationstation") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedinscriber") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedhydrophonic") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedresearch") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedpipe") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedironscaff") || registryName.equalsIgnoreCase("tconstruct:clear_glass")) {
                return false;
            }
            ArrayList list = new ArrayList();
            block.func_185477_a(block.func_176223_P(), null, BlockPos.field_177992_a, Block.field_185505_j, list, null);
            return list.size() == 1 && ((AxisAlignedBB)list.get(0)).equals((Object)Block.field_185505_j);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean enable() {
        if (this.enabled || this.missingTextures) {
            return false;
        }
        this.enabled = true;
        ItemBlockArmor[] armors = new ItemBlockArmor[]{this.helmet, this.chestplate, this.leggings, this.boots};
        for (ItemBlockArmor armor : armors) {
            if (this.isFromModdedBlock) {
                if (BlockArmor.moddedTab == null) {
                    BlockArmor.moddedTab = new BlockArmorCreativeTab("tabBlockArmorModded");
                }
                BlockArmor.moddedTab.orderedStacks.add(new ItemStack((Item)armor));
                armor.func_77637_a(BlockArmor.moddedTab);
                continue;
            }
            if (BlockArmor.vanillaTab == null) {
                BlockArmor.vanillaTab = new BlockArmorCreativeTab("tabBlockArmorVanilla");
            }
            BlockArmor.vanillaTab.orderedStacks.add(new ItemStack((Item)armor));
            armor.func_77637_a(BlockArmor.vanillaTab);
        }
        for (IRecipe recipe : this.recipes) {
            if (CraftingManager.func_77594_a().func_77592_b().contains(recipe)) continue;
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
        return true;
    }

    public boolean disable() {
        if (!this.enabled) {
            return false;
        }
        this.enabled = false;
        ItemBlockArmor[] armors = new ItemBlockArmor[]{this.helmet, this.chestplate, this.leggings, this.boots};
        block0: for (ItemBlockArmor armor : armors) {
            armor.func_77637_a(null);
            if (BlockArmor.vanillaTab != null && BlockArmor.vanillaTab.orderedStacks != null) {
                for (ItemStack tabStack : BlockArmor.vanillaTab.orderedStacks) {
                    if (tabStack.func_77973_b() != armor) continue;
                    BlockArmor.vanillaTab.orderedStacks.remove(tabStack);
                    break;
                }
            }
            if (BlockArmor.moddedTab == null || BlockArmor.moddedTab.orderedStacks == null) continue;
            for (ItemStack tabStack : BlockArmor.moddedTab.orderedStacks) {
                if (tabStack.func_77973_b() != armor) continue;
                BlockArmor.moddedTab.orderedStacks.remove(tabStack);
                continue block0;
            }
        }
        for (IRecipe recipe : this.recipes) {
            if (!CraftingManager.func_77594_a().func_77592_b().contains(recipe)) continue;
            CraftingManager.func_77594_a().func_77592_b().remove(recipe);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Tuple<Integer, Boolean> initTextures() {
        boolean missingTextures = false;
        if (missingSprite == null) {
            missingSprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        int numTextures = 0;
        this.sprites = new TextureAtlasSprite[EntityEquipmentSlot.values().length];
        this.animations = new AnimationMetadataSection[EntityEquipmentSlot.values().length];
        this.frames = new float[EntityEquipmentSlot.values().length];
        this.colors = new int[EntityEquipmentSlot.values().length];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = -1;
        }
        ArrayList list = new ArrayList();
        try {
            ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            list.addAll(mesher.func_178089_a(this.stack).func_188616_a(null, null, 0L));
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                list.addAll(mesher.func_178089_a(this.stack).func_188616_a(null, facing, 0L));
            }
            for (BakedQuad quad : list) {
                int color;
                ResourceLocation loc1 = new ResourceLocation(quad.func_187508_a().func_94215_i());
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(loc1.toString());
                AnimationMetadataSection animation = (AnimationMetadataSection)(sprite.func_110970_k() > 1 ? ReflectionHelper.getPrivateValue(TextureAtlasSprite.class, (Object)sprite, (int)3) : null);
                int n = color = quad.func_178212_b() ? Minecraft.func_71410_x().getItemColors().func_186728_a(this.stack, quad.func_178211_c()) : -1;
                if (sprite.func_94215_i().contains("overlay")) continue;
                if (quad.func_178210_d() == EnumFacing.UP) {
                    if (sprite != missingSprite) {
                        ++numTextures;
                    }
                    this.sprites[EntityEquipmentSlot.HEAD.func_188454_b()] = sprite;
                    this.animations[EntityEquipmentSlot.HEAD.func_188454_b()] = animation;
                    this.colors[EntityEquipmentSlot.HEAD.func_188454_b()] = color;
                    continue;
                }
                if (quad.func_178210_d() == EnumFacing.NORTH) {
                    if (sprite != missingSprite) {
                        ++numTextures;
                    }
                    this.sprites[EntityEquipmentSlot.CHEST.func_188454_b()] = sprite;
                    this.animations[EntityEquipmentSlot.CHEST.func_188454_b()] = animation;
                    this.colors[EntityEquipmentSlot.CHEST.func_188454_b()] = color;
                    continue;
                }
                if (quad.func_178210_d() == EnumFacing.SOUTH) {
                    if (sprite != missingSprite) {
                        ++numTextures;
                    }
                    this.sprites[EntityEquipmentSlot.LEGS.func_188454_b()] = sprite;
                    this.animations[EntityEquipmentSlot.LEGS.func_188454_b()] = animation;
                    this.colors[EntityEquipmentSlot.LEGS.func_188454_b()] = color;
                    continue;
                }
                if (quad.func_178210_d() != EnumFacing.DOWN) continue;
                if (sprite != missingSprite) {
                    ++numTextures;
                }
                this.sprites[EntityEquipmentSlot.FEET.func_188454_b()] = sprite;
                this.animations[EntityEquipmentSlot.FEET.func_188454_b()] = animation;
                this.colors[EntityEquipmentSlot.FEET.func_188454_b()] = color;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TEXTURE_OVERRIDES.contains(this.item)) {
            for (EntityEquipmentSlot slot : SLOTS) {
                ResourceLocation texture = new ResourceLocation("blockarmor:textures/items/overrides/" + this.item.getRegistryName().func_110623_a().toLowerCase().replace(" ", "_") + "_" + slot.func_188450_d() + ".png");
                try {
                    TextureAtlasSprite sprite;
                    Minecraft.func_71410_x().func_110442_L().func_110536_a(texture);
                    texture = new ResourceLocation(texture.func_110624_b(), texture.func_110623_a().replace("textures/", "").replace(".png", ""));
                    this.sprites[slot.func_188454_b()] = sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
                    this.animations[slot.func_188454_b()] = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.sprites[EntityEquipmentSlot.HEAD.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.CHEST.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.LEGS.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.FEET.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.HEAD.func_188454_b()] == missingSprite || this.sprites[EntityEquipmentSlot.CHEST.func_188454_b()] == missingSprite || this.sprites[EntityEquipmentSlot.LEGS.func_188454_b()] == missingSprite || this.sprites[EntityEquipmentSlot.FEET.func_188454_b()] == missingSprite) {
            missingTextures = true;
        }
        this.isTranslucent = this.block.func_180664_k() != BlockRenderLayer.SOLID && this.block != Blocks.field_150436_aH;
        return new Tuple((Object)numTextures, (Object)missingTextures);
    }

    static {
        SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    }
}

