/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectLucky
extends SetEffect {
    protected SetEffectLucky() {
        this.color = TextFormatting.DARK_GREEN;
        this.description = "Greatly increases Fortune, Looting, and Luck";
        this.attributeModifiers.add(new AttributeModifier(LUCK_UUID, SharedMonsterAttributes.field_188792_h.func_111108_a(), 3.0, 0));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void addLooting(LootingLevelEvent event) {
        if (event.getDamageSource().func_76346_g() instanceof EntityPlayer && event.getEntity().field_70170_p instanceof WorldServer && ArmorSet.getWornSetEffects((EntityLivingBase)event.getDamageSource().func_76346_g()).contains(this)) {
            event.setLootingLevel(event.getLootingLevel() + 4);
            this.doParticlesAndSound((WorldServer)event.getEntity().field_70170_p, event.getEntity().func_180425_c(), (EntityPlayer)event.getDamageSource().func_76346_g(), 4.0f);
        }
    }

    @SubscribeEvent
    public void addFortune(BlockEvent.HarvestDropsEvent event) {
        List newDrops;
        if (ArmorSet.getWornSetEffects((EntityLivingBase)event.getHarvester()).contains(this) && event.getWorld() instanceof WorldServer && (newDrops = event.getState().func_177230_c().getDrops((IBlockAccess)event.getWorld(), event.getPos(), event.getState(), event.getFortuneLevel() + 4)).size() > event.getDrops().size()) {
            this.doParticlesAndSound((WorldServer)event.getWorld(), event.getPos(), event.getHarvester(), newDrops.size() - event.getDrops().size());
            event.getDrops().clear();
            event.getDrops().addAll(newDrops);
            this.damageArmor((EntityLivingBase)event.getHarvester(), 1, false);
        }
    }

    private void doParticlesAndSound(WorldServer world, BlockPos pos, EntityPlayer player, float amplifier) {
        world.func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5, (double)0.4f, (double)0.4f, (double)0.4f, 0.0, new int[0]);
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.05f * amplifier, world.field_73012_v.nextFloat() + 0.9f);
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        return SetEffect.registryNameContains(block, meta, new String[]{"emerald", "luck"});
    }
}

