/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.config;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;
import twopiradians.blockArmor.jei.BlockArmorJEIPlugin;
import twopiradians.blockArmor.packet.PacketSyncConfig;

public class Config {
    public static Configuration config;
    public static final String SET_EFFECTS_CATEGORY = "config.setEffects";
    public static final String ARMOR_SETS_CATEGORY = "config.armorSets";
    private static final float CONFIG_VERSION = 2.4f;
    public static int piecesForSet;
    public static ArrayList<Class> disabledSetEffects;
    public static boolean registerDisabledItems;
    public static ArrayList<ArmorSet> disabledSets;
    public static boolean effectsUseDurability;
    private static HashMap<String, String> modList;

    public static void postInit(File file) {
        String version;
        config = new Configuration(file, String.valueOf(2.4f));
        config.load();
        modList = Maps.newHashMap();
        for (Object modid : Loader.instance().getIndexedModList().keySet()) {
            modList.put(((String)modid).toLowerCase(), ((ModContainer)Loader.instance().getIndexedModList().get(modid)).getName());
        }
        if (!modList.containsKey("minecraft")) {
            modList.put("minecraft", "Minecraft");
        }
        if ((version = config.getLoadedConfigVersion()) == null || Float.parseFloat(version) < 2.4f) {
            for (String category : config.getCategoryNames()) {
                config.removeCategory(config.getCategory(category));
            }
            BlockArmor.logger.warn("Deleted config from older version");
        }
        Property prop = Config.getRegisterDisableItemsProp();
        registerDisabledItems = prop.getBoolean();
        disabledSets = new ArrayList();
        if (!registerDisabledItems) {
            config.getCategory(ARMOR_SETS_CATEGORY).setComment("Enable or disable armor sets.");
            for (ArmorSet set : ArmorSet.allSets) {
                String name = modList.get(set.modid) == null ? "???" : modList.get(set.modid);
                ConfigCategory category = config.getCategory("config.armorSets." + name.replace(".", ","));
                category.setComment("Enable or disable armor made from " + name + " blocks.");
                prop = Config.getArmorSetProp(name, set);
                if (prop.getBoolean()) continue;
                disabledSets.add(set);
            }
        }
    }

    public static void syncConfig() {
        disabledSetEffects = new ArrayList();
        config.getCategory(ARMOR_SETS_CATEGORY).setComment("Enable or disable armor sets.");
        for (ArmorSet set : ArmorSet.allSets) {
            String name = modList.get(set.modid) == null ? "???" : modList.get(set.modid);
            ConfigCategory category = config.getCategory("config.armorSets." + name.replace(".", ","));
            category.setComment("Enable or disable armor made from " + name + " blocks.");
            Property prop = Config.getArmorSetProp(name, set);
            if (prop.getBoolean()) {
                set.enable();
                continue;
            }
            set.disable();
        }
        config.getCategory(SET_EFFECTS_CATEGORY).setComment("Enable or disable set effects.");
        for (SetEffect effect : SetEffect.SET_EFFECTS) {
            Property prop = Config.getSetEffectProp(effect.toString());
            if (prop.getBoolean()) continue;
            disabledSetEffects.add(effect.getClass());
        }
        Property prop = Config.getPiecesForSetProp();
        piecesForSet = prop.getInt();
        prop = Config.getEffectsUseDurablityProp();
        effectsUseDurability = prop.getBoolean();
        prop = Config.getRegisterDisableItemsProp();
        registerDisabledItems = prop.getBoolean();
        config.save();
        Config.syncJEIBlacklist();
    }

    public static Property getEffectsUseDurablityProp() {
        Property prop = config.get("general", "Set Effects use durability", false, "Should Set Effects use durability of worn armor to work");
        return prop;
    }

    public static Property getRegisterDisableItemsProp() {
        Property prop = config.get("general", "Register disabled items", true, "Should only need to be changed in the very rare scenario that your world is using all of its item ID's (32k).\n" + TextFormatting.DARK_GREEN + "True: all armor sets will be registered and you can freely enable/disable armor sets without restarting.\n" + TextFormatting.DARK_RED + "False: only enabled armor sets will be registered and you need to restart whenever armor sets are enabled/disabled. Players joining a server with disabled armor sets may need to restart their clients after joining to sync their registered items.");
        prop.setRequiresMcRestart(true);
        return prop;
    }

    public static Property getSetEffectProp(String effectName) {
        Property prop = effectName.equalsIgnoreCase("Diorite Vision") ? config.get(SET_EFFECTS_CATEGORY, effectName, false, "Determines whether or not the " + effectName + " set effect can be used.") : config.get(SET_EFFECTS_CATEGORY, effectName, true, "Determines whether or not the " + effectName + " set effect can be used.");
        return prop;
    }

    public static Property getArmorSetProp(String modName, ArmorSet set) {
        String name = ArmorSet.getItemStackRegistryName(set.stack);
        Property prop = config.get("config.armorSets." + modName.replace(".", ","), name + " Armor", true, "Determines whether or not the " + ArmorSet.getItemStackDisplayName(set.stack, null) + " armor should be generated.");
        if (!registerDisabledItems) {
            prop.setRequiresMcRestart(true);
        }
        return prop;
    }

    public static Property getPiecesForSetProp() {
        Property prop = config.get("general", "Armor pieces required for Set Effects", 4, "Specifies how many armor pieces must be worn for a set's effect(s) to work.", 1, 4);
        if (prop.getInt() > 4) {
            prop.set(4);
        } else if (prop.getInt() < 1) {
            prop.set(1);
        }
        return prop;
    }

    public static void syncJEIBlacklist() {
        if (Loader.isModLoaded((String)"jei")) {
            BlockArmorJEIPlugin.syncJEIBlacklist();
        }
    }

    @SubscribeEvent
    public void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player != null && event.player instanceof EntityPlayerMP) {
            Config.syncConfig();
            BlockArmor.network.sendTo((IMessage)new PacketSyncConfig(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("blockarmor")) {
            if (event.isWorldRunning() && FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                BlockArmor.logger.warn("Config changes will not be saved while on a server.");
                config.save();
            } else {
                Config.syncConfig();
            }
        }
    }
}

