/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.client.gui.armorDisplay.EntityGuiPlayer;
import twopiradians.blockArmor.client.key.KeyActivateSetEffect;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;
import twopiradians.blockArmor.common.seteffect.SetEffectAbsorbent;
import twopiradians.blockArmor.common.seteffect.SetEffectArrow_Defence;
import twopiradians.blockArmor.common.seteffect.SetEffectAutoSmelt;
import twopiradians.blockArmor.common.seteffect.SetEffectBonemealer;
import twopiradians.blockArmor.common.seteffect.SetEffectCrafter;
import twopiradians.blockArmor.common.seteffect.SetEffectDiorite_Vision;
import twopiradians.blockArmor.common.seteffect.SetEffectDiving_Suit;
import twopiradians.blockArmor.common.seteffect.SetEffectEnder;
import twopiradians.blockArmor.common.seteffect.SetEffectEnder_Hoarder;
import twopiradians.blockArmor.common.seteffect.SetEffectExperience_Giving;
import twopiradians.blockArmor.common.seteffect.SetEffectExplosive;
import twopiradians.blockArmor.common.seteffect.SetEffectFalling;
import twopiradians.blockArmor.common.seteffect.SetEffectFeeder;
import twopiradians.blockArmor.common.seteffect.SetEffectFiery;
import twopiradians.blockArmor.common.seteffect.SetEffectFlame_Resistant;
import twopiradians.blockArmor.common.seteffect.SetEffectFrosty;
import twopiradians.blockArmor.common.seteffect.SetEffectHealth_Boost;
import twopiradians.blockArmor.common.seteffect.SetEffectIlluminated;
import twopiradians.blockArmor.common.seteffect.SetEffectImmovable;
import twopiradians.blockArmor.common.seteffect.SetEffectInvisibility;
import twopiradians.blockArmor.common.seteffect.SetEffectLightweight;
import twopiradians.blockArmor.common.seteffect.SetEffectLucky;
import twopiradians.blockArmor.common.seteffect.SetEffectMusical;
import twopiradians.blockArmor.common.seteffect.SetEffectPowerful;
import twopiradians.blockArmor.common.seteffect.SetEffectPrickly;
import twopiradians.blockArmor.common.seteffect.SetEffectPuller;
import twopiradians.blockArmor.common.seteffect.SetEffectPusher;
import twopiradians.blockArmor.common.seteffect.SetEffectRegrowth;
import twopiradians.blockArmor.common.seteffect.SetEffectSlimey;
import twopiradians.blockArmor.common.seteffect.SetEffectSlippery;
import twopiradians.blockArmor.common.seteffect.SetEffectSlow_Motion;
import twopiradians.blockArmor.common.seteffect.SetEffectSnowy;
import twopiradians.blockArmor.common.seteffect.SetEffectSoft_Fall;
import twopiradians.blockArmor.common.seteffect.SetEffectSpeedy;
import twopiradians.blockArmor.common.seteffect.SetEffectTime_Control;

public class SetEffect {
    public static final UUID ATTACK_SPEED_UUID = UUID.fromString("3094e67f-88f1-4d81-a59d-655d4e7e8065");
    public static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("d7dfa4ea-1cdf-4dd9-8842-883d7448cb00");
    protected static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("308e48ee-a300-4846-9b56-05e53e35eb8f");
    protected static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("c8bb1118-78be-4864-9de3-a718047d28bd");
    protected static final UUID MAX_HEALTH_UUID = UUID.fromString("0fefa40c-fd5a-4019-a25e-7fffc8dcf621");
    protected static final UUID LUCK_UUID = UUID.fromString("537fd0e2-78ef-4dd3-affb-959ff059b1bd");
    public static final ArrayList<SetEffect> SET_EFFECTS = new ArrayList<SetEffect>(){
        {
            this.add(new SetEffectDiorite_Vision());
            this.add(new SetEffectCrafter());
            this.add(new SetEffectEnder_Hoarder());
            this.add(new SetEffectIlluminated(0));
            this.add(new SetEffectSnowy());
            this.add(new SetEffectEnder());
            this.add(new SetEffectAbsorbent());
            this.add(new SetEffectExplosive());
            this.add(new SetEffectTime_Control(null));
            this.add(new SetEffectPusher());
            this.add(new SetEffectPuller());
            this.add(new SetEffectArrow_Defence());
            this.add(new SetEffectBonemealer());
            this.add(new SetEffectMusical());
            this.add(new SetEffectSlow_Motion());
            this.add(new SetEffectSoft_Fall());
            this.add(new SetEffectFeeder());
            this.add(new SetEffectLightweight());
            this.add(new SetEffectInvisibility());
            this.add(new SetEffectImmovable(0.0));
            this.add(new SetEffectLucky());
            this.add(new SetEffectFiery());
            this.add(new SetEffectFrosty());
            this.add(new SetEffectRegrowth());
            this.add(new SetEffectPrickly());
            this.add(new SetEffectSlimey());
            this.add(new SetEffectSpeedy());
            this.add(new SetEffectFlame_Resistant());
            this.add(new SetEffectAutoSmelt());
            this.add(new SetEffectHealth_Boost(0.0));
            this.add(new SetEffectDiving_Suit());
            this.add(new SetEffectExperience_Giving());
            this.add(new SetEffectSlippery());
            this.add(new SetEffectFalling());
            this.add(new SetEffectPowerful());
        }
    };
    protected boolean usesButton;
    protected TextFormatting color;
    protected ArrayList<PotionEffect> potionEffects = new ArrayList();
    protected ArrayList<AttributeModifier> attributeModifiers = new ArrayList();
    protected ArrayList<EnchantmentData> enchantments = new ArrayList();
    public String description;

    public static void postInit() {
        for (ArmorSet set : ArmorSet.allSets) {
            boolean hasEffectWithButton = false;
            set.setEffects = new ArrayList();
            for (SetEffect effect : SET_EFFECTS) {
                if (!effect.isValid(set.block, set.meta) || effect.usesButton && hasEffectWithButton) continue;
                if (effect.usesButton) {
                    hasEffectWithButton = true;
                }
                set.setEffects.add(effect.create(set.block));
            }
        }
    }

    protected static boolean registryNameContains(Block block, int meta, String[] strings) {
        try {
            String registryName = block.getRegistryName().func_110623_a();
            String displayName = new ItemStack(block, 1, meta).func_82833_r();
            for (String string : strings) {
                if (!registryName.contains(string) && !registryName.contains(string.substring(0, 1).toUpperCase() + string.substring(1)) && !displayName.contains(string.substring(0, 1).toUpperCase() + string.substring(1))) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean isEnabled() {
        return !Config.disabledSetEffects.contains(this.getClass());
    }

    protected SetEffect create(Block block) {
        return this;
    }

    protected boolean isValid(Block block, int meta) {
        return false;
    }

    protected boolean shouldApplyPotionEffect(PotionEffect potionEffect, World world, EntityPlayer player, ItemStack stack) {
        return true;
    }

    protected void damageArmor(EntityLivingBase entity, int amount, boolean ignoreConfig) {
        if (!ignoreConfig && !Config.effectsUseDurability || entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        ArrayList<ItemStack> armor = new ArrayList<ItemStack>();
        for (EntityEquipmentSlot slot : ArmorSet.SLOTS) {
            ItemStack stack = entity.func_184582_a(slot);
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlockArmor) || !((ItemBlockArmor)stack.func_77973_b()).set.setEffects.contains(this)) continue;
            armor.add(stack);
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack highestDur = null;
            for (ItemStack stack : armor) {
                if (stack.func_190926_b() || highestDur != null && stack.func_77958_k() - stack.func_77952_i() <= highestDur.func_77958_k() - highestDur.func_77952_i()) continue;
                highestDur = stack;
            }
            if (highestDur != null && highestDur.func_77958_k() - highestDur.func_77952_i() == 0) {
                armor.remove(highestDur);
                entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.8f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                highestDur.func_190918_g(1);
                continue;
            }
            if (highestDur == null) continue;
            highestDur.func_77972_a(1, entity);
        }
    }

    protected void setCooldown(EntityPlayer player, int ticks) {
        if (player != null) {
            for (EntityEquipmentSlot slot : ArmorSet.SLOTS) {
                ItemStack stack = player.func_184582_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof ItemBlockArmor) || !((ItemBlockArmor)stack.func_77973_b()).set.setEffects.contains(this)) continue;
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ticks);
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack) {
            for (PotionEffect potionEffect : this.potionEffects) {
                if (!this.shouldApplyPotionEffect(potionEffect, world, player, stack)) continue;
                player.func_70690_d(new PotionEffect(potionEffect));
            }
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K) {
            if (!this.attributeModifiers.isEmpty()) {
                if (!(entity instanceof EntityLivingBase && ArmorSet.getWornSetEffects((EntityLivingBase)entity).contains(this) && ((EntityLivingBase)entity).func_184582_a(((ItemBlockArmor)stack.func_77973_b()).field_77881_a) == stack && this.isEnabled())) {
                    stack.func_77978_p().func_74757_a("wearingFullSet", false);
                } else {
                    stack.func_77978_p().func_74757_a("wearingFullSet", true);
                }
            }
            if (!this.enchantments.isEmpty()) {
                NBTTagList enchantNbt = stack.func_77978_p().func_150295_c("ench", 10);
                for (EnchantmentData enchant : this.enchantments) {
                    int i;
                    if (((ItemBlockArmor)stack.func_77973_b()).field_77881_a != enchant.slot) continue;
                    boolean hasEnchant = false;
                    for (i = 0; i < enchantNbt.func_74745_c(); ++i) {
                        if (enchantNbt.func_150305_b(i).func_74765_d("id") != (short)Enchantment.func_185258_b((Enchantment)enchant.ench) || enchantNbt.func_150305_b(i).func_74765_d("lvl") < enchant.level) continue;
                        hasEnchant = true;
                    }
                    if (hasEnchant && (!(entity instanceof EntityLivingBase) || !ArmorSet.getWornSetEffects((EntityLivingBase)entity).contains(this) || !this.isEnabled()) || ((EntityLivingBase)entity).func_184582_a(((ItemBlockArmor)stack.func_77973_b()).field_77881_a) != stack) {
                        for (i = enchantNbt.func_74745_c() - 1; i >= 0; --i) {
                            if (!enchantNbt.func_150305_b(i).func_74767_n("blockarmor enchant")) continue;
                            enchantNbt.func_74744_a(i);
                        }
                        continue;
                    }
                    if (hasEnchant || ((EntityLivingBase)entity).func_184582_a(((ItemBlockArmor)stack.func_77973_b()).field_77881_a) != stack || !ArmorSet.getWornSetEffects((EntityLivingBase)entity).contains(this) || !this.isEnabled()) continue;
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)enchant.ench));
                    nbt.func_74777_a("lvl", enchant.level.shortValue());
                    nbt.func_74757_a("blockarmor enchant", true);
                    enchantNbt.func_74742_a((NBTBase)nbt);
                }
                if (enchantNbt.func_82582_d()) {
                    stack.func_77978_p().func_82580_o("ench");
                } else {
                    stack.func_77978_p().func_74782_a("ench", (NBTBase)enchantNbt);
                }
            }
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(Multimap<String, AttributeModifier> map, EntityEquipmentSlot slot, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74767_n("wearingFullSet")) {
            for (AttributeModifier attribute : this.attributeModifiers) {
                map.put((Object)attribute.func_111166_b(), (Object)attribute);
            }
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> addInformation(ItemStack stack, boolean isShiftDown, EntityPlayer player, List<String> tooltip, boolean advanced) {
        String string = this.color.toString();
        if (player instanceof EntityGuiPlayer || ArmorSet.getWornSetEffects((EntityLivingBase)player).contains(this) && player.func_184582_a(((ItemBlockArmor)stack.func_77973_b()).field_77881_a) == stack) {
            string = string + TextFormatting.BOLD;
        }
        string = string + (this.isEnabled() ? "" : TextFormatting.STRIKETHROUGH.toString());
        string = string + this.toString() + TextFormatting.RESET;
        if (isShiftDown) {
            string = string + this.color;
            string = string + (this.isEnabled() ? "" : TextFormatting.STRIKETHROUGH.toString());
            string = string + ": " + TextFormatting.ITALIC + this.description + TextFormatting.RESET;
            if (this.usesButton) {
                string = string + TextFormatting.BLUE + " <" + TextFormatting.BOLD + KeyActivateSetEffect.ACTIVATE_SET_EFFECT.getDisplayName() + TextFormatting.RESET + "" + TextFormatting.BLUE + ">";
            }
        }
        tooltip.add(string);
        return tooltip;
    }

    public String toString() {
        return this.getClass().getSimpleName().replace("SetEffect", "").replace("_", " ");
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass() && this.description.equals(((SetEffect)obj).description);
    }

    static class EnchantmentData {
        public Enchantment ench;
        public Short level;
        public EntityEquipmentSlot slot;

        public EnchantmentData(Enchantment ench, Short level, EntityEquipmentSlot slot) {
            this.ench = ench;
            this.level = level;
            this.slot = slot;
        }
    }
}

