/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.jei;

import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;

@JEIPlugin
public class BlockArmorJEIPlugin
implements IModPlugin {
    private static IModRegistry registry;

    public void register(IModRegistry registry) {
        BlockArmorJEIPlugin.registry = registry;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        BlockArmorJEIPlugin.syncJEIIngredients();
    }

    public static void syncJEIIngredients() {
        if (registry != null) {
            ArrayList ingredients = new ArrayList(registry.getIngredientRegistry().getAllIngredients(ItemStack.class));
            ArrayList<ItemStack> ingredientsToAdd = new ArrayList<ItemStack>();
            ArrayList<ItemStack> ingredientsToRemove = new ArrayList<ItemStack>();
            for (ArmorSet set : ArmorSet.allSets) {
                if (set.isEnabled()) {
                    for (ItemBlockArmor armor : new ItemBlockArmor[]{set.helmet, set.chestplate, set.leggings, set.boots}) {
                        if (registry.getJeiHelpers().getStackHelper().containsAnyStack(ingredients, Collections.singletonList(new ItemStack((Item)armor))) != null) continue;
                        ingredientsToAdd.add(new ItemStack((Item)armor));
                    }
                    continue;
                }
                for (ItemBlockArmor armor : new ItemBlockArmor[]{set.helmet, set.chestplate, set.leggings, set.boots}) {
                    if (registry.getJeiHelpers().getStackHelper().containsAnyStack(ingredients, Collections.singletonList(new ItemStack((Item)armor))) == null) continue;
                    ingredientsToRemove.add(registry.getJeiHelpers().getStackHelper().containsAnyStack(ingredients, Collections.singletonList(new ItemStack((Item)armor))));
                }
            }
            if (!ingredientsToAdd.isEmpty()) {
                registry.getIngredientRegistry().addIngredientsAtRuntime(ItemStack.class, ingredientsToAdd);
                BlockArmor.logger.info("Added " + ingredientsToAdd.size() + " items to JEI");
            }
            if (!ingredientsToRemove.isEmpty()) {
                registry.getIngredientRegistry().removeIngredientsAtRuntime(ItemStack.class, ingredientsToRemove);
                BlockArmor.logger.info("Removed " + ingredientsToRemove.size() + " items from JEI");
            }
        }
    }
}

