const { app, Menu, Tray, BrowserWindow, ipcMain } = require('electron');

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let win;
var path = require('path');
const iconPath = path.join(__dirname, '/asserts/fengdong/png/16x16.png');
let appIcon = null;
const packageJson = require(`${__dirname}/package.json`);

function createWindow() {
    var force_quit = false;
    // Create the browser window.
    win = new BrowserWindow({
        width: 1024,
        height: 670,
        minWidth: 1024,
        minHeight: 670,
        backgroundColor: '#cccccc',
        icon: path.join(__dirname, '/asserts/fengdong/png/64x64.png')
    });

    win.setMenu(null);

    function menus() {
        if (win.isVisible()) {
            var m = [{
                label: '关闭窗口',
                type: 'radio',
                accelerator: 'Command+W',
                click: function() {
                    win.hide();
                }
            }];
        } else {
            var m = [{
                label: '显示窗口',
                type: 'radio',
                accelerator: 'Command+S',
                click: function() {
                    win.show();
                }
            }, ];
        }
        m.push({
            label: '退出',
            accelerator: 'Command+Q',
            click: function() {
                force_quit = true;
                app.quit();
            }
        });
        return m;
    }
    appIcon = new Tray(iconPath);
    appIcon.setToolTip('蜂洞微信扫码点餐系统');

    function cmenu() {
        appIcon.setContextMenu(Menu.buildFromTemplate(menus()));
    }
    cmenu();

    appIcon.on('double-click', (e) => {
        console.log("--------点击1")
    });

    appIcon.on('right-click', (e) => {
        console.log("--------点击1")
    });

    appIcon.on('click', (e) => {
        console.log("--------点击")
        win.show();
    });

    // win.setOverlayIcon(__dirname + '/asserts/fengdong/png/64x64.png',"test?");

    // and load the index.html of the app.
    win.loadURL(packageJson.dev ? `https://www.fengdong8.com/home` : `https://www.fengdong8.com/home?ref=electron`);

    // Open the DevTools.
    if (packageJson.dev) {
        win.webContents.openDevTools();
    }

    win.onbeforeunload = function(e) {
        if (!force_quit) {
            e.preventDefault();
            e.returnValue = false;
            win.hide();
        }
        cmenu();
    };

    win.on('close', (e) => {
        if (!force_quit) {
            e.preventDefault();
            win.hide();
        }
        cmenu();
    });

    win.on('hide', (e) => {
        cmenu();
    });

    win.on('show', (e) => {
        cmenu();
    });

    // Emitted when the window is closed.
    win.on('closed', () => {
        // Dereference the window object, usually you would store windows
        // in an array if your app supports multi windows, this is the time
        // when you should delete the corresponding element.
        win = null;
    });
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', createWindow);

// Quit when all windows are closed.
app.on('window-all-closed', () => {
    // On OS X it is common for applications and their menu bar
    // to stay active until the user quits explicitly with Cmd + Q
    if (process.platform !== 'darwin') {
        app.quit();
    }
});

app.on('activate', () => {
    // On OS X it's common to re-create a window in the app when the
    // dock icon is clicked and there are no other windows open.
    if (win === null) {
        createWindow();
    }
});

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.