function init()
  data.active = false
  data.fireTimer1 = 0
  data.fireTimer2 = 0
  tech.setVisible(false)
  tech.rotateGroup("guns", 0, true)
  data.holdingUp = false
  data.holdingDown = false
  data.walking = false
end

function uninit()
  if data.active then
    local mechTransformPositionChange = tech.parameter("mechTransformPositionChange")
    tech.translate({-mechTransformPositionChange[1], -mechTransformPositionChange[2]})
    tech.setParentOffset({0, 0})
    data.active = false
    tech.setVisible(false)
    tech.setParentAppearance("normal")
    tech.setToolUsageSuppressed(false)
    tech.setParentFacingDirection(nil)
  end
end

function input(args)
  
  if args.moves["up"] then
    data.holdingUp = true
  elseif not args.moves["up"] then
    data.holdingUp = false
  end
  
  if args.moves["down"] then
    data.holdingDown = true
  elseif not args.moves["down"] then
    data.holdingDown = false
  end
  
  if args.moves["left"] or args.moves["right"] then
    data.walking = true
  else
    data.walking = false
  end

  if args.moves["special"] == 1 then
    if data.active then
      return "mechDeactivate"
    else
      return "mechActivate"
    end
  elseif args.moves["primaryFire"] then
    return "mechFire"
  elseif args.moves["altFire"] then
    return "mechFire2"
  end

  return nil
end

function update(args)
  -- get parameters from ufomech.tech
  local mechCustomMovementParameters = tech.parameter("mechCustomMovementParameters")
  local mechTransformPositionChange = tech.parameter("mechTransformPositionChange")
  local parentOffset = tech.parameter("parentOffset")
  local mechCollisionTest = tech.parameter("mechCollisionTest")
  local mechFireCycle = tech.parameter("mechFireCycle")
  local mechProjectile = tech.parameter("mechProjectile")
  local mechProjectileConfig = tech.parameter("mechProjectileConfig")

  -- activate mech
  if not data.active and args.actions["mechActivate"] then
    -- check for collision
    mechCollisionTest[1] = mechCollisionTest[1] + tech.position()[1]
    mechCollisionTest[2] = mechCollisionTest[2] + tech.position()[2]
    mechCollisionTest[3] = mechCollisionTest[3] + tech.position()[1]
    mechCollisionTest[4] = mechCollisionTest[4] + tech.position()[2]
    if not world.rectCollision(mechCollisionTest) then
      tech.translate(mechTransformPositionChange)
      tech.setVisible(true)
      tech.setParentAppearance("sit")
      tech.setToolUsageSuppressed(true)
      tech.setParentOffset(parentOffset)
      data.active = true
    else
      -- Make some kind of error noise
    end
	
  --deactivate mech
  elseif data.active and args.actions["mechDeactivate"]  then
    tech.translate({-mechTransformPositionChange[1], -mechTransformPositionChange[2]})
    tech.setVisible(false)
    tech.setParentAppearance("normal")
    tech.setToolUsageSuppressed(false)
    tech.setParentOffset({0, 0})
    data.active = false
  end

  tech.setParentFacingDirection(nil)
  
  if data.active then
    -- calculate aiming angle
    local diff = world.distance(args.aimPosition, tech.position())
    local aimAngle = math.atan2(diff[2], diff[1])
    local flip = aimAngle > math.pi / 2 or aimAngle < -math.pi / 2

    tech.applyMovementParameters(mechCustomMovementParameters)
	
	-- set the direction of the player and make sure that the gun does can not face above the horizon
    if flip then
      tech.setParentFacingDirection(-1)
	  if aimAngle > 0 then
		aimAngle = -179
	  end
    else
      tech.setParentFacingDirection(1)
	  if aimAngle > 0 then
		aimAngle = 0
	  end
    end
	
	-- rotate the gun towards the pointer
	tech.rotateGroup("guns",aimAngle)
	
	-- move vehicle up and down (left and right work with standard walking) and set state to "moving"/"idle"
	if data.active and data.holdingUp then
		tech.yControl(tech.parameter("upDownSpeed"), 1000, true)
		tech.setAnimationState("movement", "moving") 
	elseif data.active and data.holdingDown then
		tech.yControl(-tech.parameter("upDownSpeed"), 1000, true)
		tech.setAnimationState("movement", "moving") 
	elseif data.active and data.walking then
		tech.setAnimationState("movement", "moving")
	else
		tech.setAnimationState("movement", "idle") 
	end

	-- firing weapon
	local energyCost = 0
    if args.actions["mechFire"] and args.availableEnergy > tech.parameter("mechFireEnergyCost") then
      if data.fireTimer1 <= 0 then
		energyCost = tech.parameter("mechFireEnergyCost")
        world.spawnProjectile(mechProjectile, tech.anchorPoint("frontGunFirePoint"), tech.parentEntityId(), {math.cos(aimAngle), math.sin(aimAngle)}, false, mechProjectileConfig)
        data.fireTimer1 = data.fireTimer1 + mechFireCycle
        tech.setAnimationState("frontFiring", "fire")
      else
        data.fireTimer1 = data.fireTimer1 - args.dt
      end
    end
	
    return energyCost
  end
  
  return 0
end
