local assets =
{
	-- Animation files used for the item.
	Asset("ANIM", "anim/spatshovel.zip"),

	-- Inventory image and atlas file used for the item.
    Asset("ATLAS", "images/inventoryimages/spatshovel.xml"),
    Asset("IMAGE", "images/inventoryimages/spatshovel.tex"),
}
prefabs = {
    "spatshovel",
}
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", -- Symbol to override.
    	"spatshovel", -- Animation bank we will use to overwrite the symbol.
    	"spatshovel") -- Symbol to overwrite it with.
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function init()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("spatshovel")
    inst.AnimState:SetBuild("spatshovel")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(17)
    --inst.components.weapon:SetRange(TUNING.SPAT_PHLEGM_ATTACKRANGE)
    inst.components.weapon:SetProjectile("spat_bomb")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/spatshovel.xml"
    inst.components.inventoryitem.imagename = "spatshovel"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(120)
    inst.components.finiteuses:SetUses(120)
	inst.components.finiteuses:SetOnFinished(inst.Remove)

    MakeHauntableLaunch(inst)

    return inst
end
return  Prefab("common/inventory/spatshovel", init, assets, prefabs)