Assets = 
{
    Asset("IMAGE", "images/inventoryimages/spiketrap.tex"),
    Asset("ATLAS", "images/inventoryimages/spiketrap.xml"),
    Asset("IMAGE", "images/inventoryimages/spiketrapsmall.tex"),
    Asset("ATLAS", "images/inventoryimages/spiketrapsmall.xml"),
}

PrefabFiles = 
{
	"spiketrap",
}

STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH

GLOBAL.TUNING.SPIKE_TRAP_DAMAGE = 75
GLOBAL.TUNING.SPIKE_TRAP_SMALL_DAMAGE = 25
GLOBAL.TUNING.SPIKE_TRAP_USES = 15
GLOBAL.TUNING.SPIKE_TRAP_SMALL_USES = 10

GLOBAL.SPIKETRAP_OPT_DIFFICULTY = GetModConfigData("OPT_DIFFICULTY")

local recipe1 = Recipe("spiketrapsmall", { Ingredient("twigs", 1), Ingredient("stinger", 3) }, RECIPETABS.WAR, TECH.SCIENCE_ONE)
recipe1.atlas = "images/inventoryimages/spiketrapsmall.xml"
local recipe2 = Recipe("spiketrap", { Ingredient("log", 1), Ingredient("flint", 1), Ingredient("stinger", 9) }, RECIPETABS.WAR, TECH.SCIENCE_TWO)
recipe2.atlas = "images/inventoryimages/spiketrap.xml"

local function update_recipe(self, ingredients, tab, level, placer, min_spacing, nounlock, numtogive)
    self.ingredients   = ingredients
    self.tab           = tab
    self.level         = level or 0
    self.level.ANCIENT = self.level.ANCIENT or 0
    self.level.MAGIC   = self.level.MAGIC or 0
    self.level.SCIENCE = self.level.SCIENCE or 0
    self.placer        = placer
    self.min_spacing   = min_spacing or 3.2
    self.nounlock      = nounlock or false
    self.numtogive     = numtogive or 1
end

local function register_recipes()
    if GLOBAL.SPIKETRAP_OPT_DIFFICULTY == 2 then
        update_recipe(recipe1, { Ingredient("twigs", 1), Ingredient("flint", 1), Ingredient("stinger", 3) }, RECIPETABS.WAR, TECH.SCIENCE_TWO)
    elseif GLOBAL.SPIKETRAP_OPT_DIFFICULTY == 1 then
        update_recipe(recipe1, { Ingredient("twigs", 1), Ingredient("stinger", 3) }, RECIPETABS.WAR, TECH.SCIENCE_ONE)
    else
        update_recipe(recipe1, { Ingredient("stinger", 2) }, RECIPETABS.WAR, TECH.SCIENCE_ONE)
    end
    if GLOBAL.SPIKETRAP_OPT_DIFFICULTY == 2 then
        update_recipe(recipe2, { Ingredient("log", 1), Ingredient("goldnugget", 1), Ingredient("stinger", 10) }, RECIPETABS.WAR, TECH.SCIENCE_TWO)
    elseif GLOBAL.SPIKETRAP_OPT_DIFFICULTY == 1 then
        update_recipe(recipe2, { Ingredient("log", 1), Ingredient("flint", 1), Ingredient("stinger", 9) }, RECIPETABS.WAR, TECH.SCIENCE_TWO)
    else
        update_recipe(recipe2, { Ingredient("log", 1), Ingredient("stinger", 6) }, RECIPETABS.WAR, TECH.SCIENCE_ONE)
    end
end

register_recipes()

GLOBAL.SPIKETRAP_REGISTER_RECIPES = register_recipes
GLOBAL.SPIKETRAP_CONFIG_SYNC = false

STRINGS.NAMES.SPIKETRAP = "蜂刺陷阱"
STRINGS.RECIPE_DESC.SPIKETRAP = "使你的敌人惊讶!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPIKETRAP = "那看起来真的很锋利..."

STRINGS.NAMES.SPIKETRAPSMALL = "小蜂刺陷阱"
STRINGS.RECIPE_DESC.SPIKETRAPSMALL = "使你的敌人惊讶!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPIKETRAPSMALL = "那看起来真的很锋利..."

AddPrefabPostInit("world_network", function(inst)
	inst:AddComponent("spiketrap_configsync")
end)
