local cooking = require("cooking")

local params = {}
local containers = { MAXITEMSLOTS = 0 }

--function containers.widgetsetup(container, prefab, data)
--    local t = data or params[prefab or container.inst.prefab]
--    if t ~= nil then
--        for k, v in pairs(t) do
--            container[k] = v
--        end
--        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
--    end
--end

function containers.widgetsetup(container, prefab, data)
    local t = data or params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
			if k=='widget' then
				for kk,vv in pairs(v) do
					if kk == 'side_align_tip' then
						container[kk] = vv
					else
						container[k..kk] = vv
					end
				end
			elseif k == 'issidewidget' then	
				container.side_widget = v
			else
				container[k] = v
			end	
        end
        container:SetNumSlots(container.widgetslotpos ~= nil and #container.widgetslotpos or 0)
    end
end

--------------------------------------------------------------------------
--[[ backpack ]]
--------------------------------------------------------------------------

params.backpack =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_backpack_2x4",
        animbuild = "ui_backpack_2x4",
        pos = Vector3(-5, -70, 0),
    },
    issidewidget = true,
    type = "pack",
}

for y = 0, 3 do
    table.insert(params.backpack.widget.slotpos, Vector3(-162, -75 * y + 114, 0))
    table.insert(params.backpack.widget.slotpos, Vector3(-162 + 75, -75 * y + 114, 0))
end

--------------------------------------------------------------------------
--[[ icepack ]]
--------------------------------------------------------------------------

params.icepack =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_icepack_2x3",
        animbuild = "ui_icepack_2x3",
        pos = Vector3(-5, -70, 0),
    },
    issidewidget = true,
    type = "pack",
}

for y = 0, 2 do
    table.insert(params.icepack.widget.slotpos, Vector3(-162, -75 * y + 75, 0))
    table.insert(params.icepack.widget.slotpos, Vector3(-162 + 75, -75 * y + 75, 0))
end

--------------------------------------------------------------------------
--[[ chester ]]
--------------------------------------------------------------------------

params.chester =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_chest_3x3",
        animbuild = "ui_chest_3x3",
        pos = Vector3(0, 200, 0),
        side_align_tip = 160,
    },
    type = "chest",
}

for y = 2, 0, -1 do
    for x = 0, 2 do
        table.insert(params.chester.widget.slotpos, Vector3(80 * x - 80 * 2 + 80, 80 * y - 80 * 2 + 80, 0))
    end
end

--------------------------------------------------------------------------
--[[ shadowchester ]]
--------------------------------------------------------------------------

params.shadowchester =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_chester_shadow_3x4",
        animbuild = "ui_chester_shadow_3x4",
        pos = Vector3(0, 220, 0),
        side_align_tip = 160,
    },
    type = "chest",
}

for y = 2.5, -0.5, -1 do
    for x = 0, 2 do
        table.insert(params.shadowchester.widget.slotpos, Vector3(75 * x - 75 * 2 + 75, 75 * y - 75 * 2 + 75, 0))
    end
end

--------------------------------------------------------------------------
--[[ hutch ]]
--------------------------------------------------------------------------

params.hutch = params.chester

--------------------------------------------------------------------------
--[[ cookpot ]]
--------------------------------------------------------------------------

params.cookpot =
{
    widget =
    {
        slotpos =
        {
            Vector3(0, 64 + 32 + 8 + 4, 0), 
            Vector3(0, 32 + 4, 0),
            Vector3(0, -(32 + 4), 0), 
            Vector3(0, -(64 + 32 + 8 + 4), 0),
        },
        animbank = "ui_cookpot_1x4",
        animbuild = "ui_cookpot_1x4",
        pos = Vector3(200, 0, 0),
        side_align_tip = 100,
        buttoninfo =
        {
            text = STRINGS.ACTIONS.COOK,
            position = Vector3(0, -165, 0),
        }
    },
    acceptsstacks = false,
    type = "cooker",
}

function params.cookpot.itemtestfn(container, item, slot)
	if not container.inst:HasTag("burnt") then 
    	return cooking.IsCookingIngredient(item.prefab)
    end
end

function params.cookpot.widget.buttoninfo.fn(inst)
    if inst.components.container ~= nil then
        BufferedAction(inst.components.container.opener, inst, ACTIONS.COOK):Do()
    elseif inst.replica.container ~= nil and not inst.replica.container:IsBusy() then
        SendRPCToServer(RPC.DoWidgetButtonAction, ACTIONS.COOK.code, inst, ACTIONS.COOK.mod_name)
    end
end

function params.cookpot.widget.buttoninfo.validfn(inst)
    return inst.replica.container ~= nil and inst.replica.container:IsFull()
end

--------------------------------------------------------------------------
--[[ mushroom_light ]]
--------------------------------------------------------------------------

params.mushroom_light =
{
    widget =
    {
        slotpos =
        {
            Vector3(0, 64 + 32 + 8 + 4, 0), 
            Vector3(0, 32 + 4, 0),
            Vector3(0, -(32 + 4), 0), 
            Vector3(0, -(64 + 32 + 8 + 4), 0),
        },
        animbank = "ui_lamp_1x4",
        animbuild = "ui_lamp_1x4",
        pos = Vector3(200, 0, 0),
        side_align_tip = 100,
    },
    acceptsstacks = false,
    type = "cooker",
}

function params.mushroom_light.itemtestfn(container, item, slot)
	if container.inst:HasTag("burnt") then
		return false
	end
	
	return item:HasTag("lightbattery")
end

--------------------------------------------------------------------------
--[[ mushroom_light2 ]]
--------------------------------------------------------------------------

params.mushroom_light2 = deepcopy(params.mushroom_light)

function params.mushroom_light2.itemtestfn(container, item, slot)
	if container.inst:HasTag("burnt") then
		return false
	end
	
	return item:HasTag("lightbattery") or item:HasTag("spore")
end


--------------------------------------------------------------------------
--[[ icebox ]]
--------------------------------------------------------------------------

params.icebox =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_chest_3x3",
        animbuild = "ui_chest_3x3",
        pos = Vector3(0, 200, 0),
        side_align_tip = 160,
    },
    type = "chest",
}

for y = 2, 0, -1 do
    for x = 0, 2 do
        table.insert(params.icebox.widget.slotpos, Vector3(80 * x - 80 * 2 + 80, 80 * y - 80 * 2 + 80, 0))
    end
end

function params.icebox.itemtestfn(container, item, slot)
    if item:HasTag("icebox_valid") then
        return true
    end

    --Perishable
    if not (item:HasTag("fresh") or item:HasTag("stale") or item:HasTag("spoiled")) then
        return false
    end

    --Edible
    for k, v in pairs(FOODTYPE) do
        if item:HasTag("edible_"..v) then
            return true
        end
    end

    return false
end

--------------------------------------------------------------------------
--[[ krampus_sack ]]
--------------------------------------------------------------------------

params.krampus_sack =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_krampusbag_2x8",
        animbuild = "ui_krampusbag_2x8",
        pos = Vector3(-5, -120, 0),
    },
    issidewidget = true,
    type = "pack",
}

for y = 0, 6 do
    table.insert(params.krampus_sack.widget.slotpos, Vector3(-162, -75 * y + 240, 0))
    table.insert(params.krampus_sack.widget.slotpos, Vector3(-162 + 75, -75 * y + 240, 0))
end

--------------------------------------------------------------------------
--[[ piggyback ]]
--------------------------------------------------------------------------

params.piggyback =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_piggyback_2x6",
        animbuild = "ui_piggyback_2x6",
        pos = Vector3(-5, -50, 0),
    },
    issidewidget = true,
    type = "pack",
}

for y = 0, 5 do
    table.insert(params.piggyback.widget.slotpos, Vector3(-162, -75 * y + 170, 0))
    table.insert(params.piggyback.widget.slotpos, Vector3(-162 + 75, -75 * y + 170, 0))
end

--------------------------------------------------------------------------
--[[ teleportato ]]
--------------------------------------------------------------------------

params.teleportato_base =
{
    widget =
    {
        slotpos =
        {
            Vector3(0, 64 + 32 + 8 + 4, 0),
            Vector3(0, 32 + 4, 0),
            Vector3(0, -(32 + 4), 0),
            Vector3(0, -(64 + 32 + 8 + 4), 0),
        },
        animbank = "ui_cookpot_1x4",
        animbuild = "ui_cookpot_1x4",
        pos = Vector3(0, 0, 0),
        side_align_tip = 100,
        type = "cooker",
        buttoninfo =
        {
            text = STRINGS.ACTIONS.ACTIVATE.GENERIC,
            position = Vector3(0, -165, 0),
        },
    },
}

function params.teleportato_base.itemtestfn(container, item, slot)
    return not item:HasTag("nonpotatable")
end

function params.teleportato_base.widget.buttoninfo.fn(inst, doer)
    --see teleportato.lua, not supported in multiplayer yet
    --CheckNextLevelSure(inst, doer)
end

--------------------------------------------------------------------------
--[[ treasurechest ]]
--------------------------------------------------------------------------

params.treasurechest =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_chest_3x3",
        animbuild = "ui_chest_3x3",
        pos = Vector3(0, 200, 0),
        side_align_tip = 160,
    },
    type = "chest",
}

for y = 2, 0, -1 do
    for x = 0, 2 do
        table.insert(params.treasurechest.widget.slotpos, Vector3(80 * x - 80 * 2 + 80, 80 * y - 80 * 2 + 80, 0))
    end
end

params.pandoraschest = params.treasurechest
params.skullchest = params.treasurechest
params.minotaurchest = params.treasurechest

params.dragonflychest = params.shadowchester

--------------------------------------------------------------------------
--[[ candybag ]]
--------------------------------------------------------------------------

params.candybag =
{
    widget =
    {
        slotpos = {},
        animbank = "ui_krampusbag_2x8",
        animbuild = "ui_krampusbag_2x8",
        pos = Vector3(-5, -120, 0),
    },
    issidewidget = true,
    type = "pack",
}

for y = 0, 6 do
    table.insert(params.candybag.widget.slotpos, Vector3(-162, -75 * y + 240, 0))
    table.insert(params.candybag.widget.slotpos, Vector3(-162 + 75, -75 * y + 240, 0))
end

function params.candybag.itemtestfn(container, item, slot)
	return item:HasTag("halloweencandy") or (string.find(item.prefab, "trinket_") == 1)
end


--------------------------------------------------------------------------

for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end

--------------------------------------------------------------------------

return containers
