local assets=
{
	Asset("ANIM", "anim/nightmarefuel.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("nightmarefuel")
    inst.AnimState:SetBuild("nightmarefuel")
    inst.AnimState:PlayAnimation("idle_loop", true)
    inst.AnimState:SetMultColour(1, 1, 1, 0.5)
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM    
    inst:AddComponent("inspectable")
local killersounds = 
{
    takeoff = "dontstarve/bee/killerbee_takeoff",
    attack = "dontstarve/bee/killerbee_attack",
    buzz = "dontstarve/bee/killerbee_fly_LP",
    hit = "dontstarve/bee/killerbee_hurt",
    death = "dontstarve/bee/killerbee_death",
}

local function OnDeploy (inst, pt)
  if GetPlayer().components.inventory:Has("goldnugget", 10) then 
    GetPlayer().components.inventory:ConsumeByName("goldnugget", 10)
    local box = SpawnPrefab("nightmarefuel")
    box.Transform:SetPosition(pt.x, pt.y, pt.z)
    box.AnimState:SetBank("bee_box")
    box.AnimState:SetBuild("bee_box")
    box.AnimState:PlayAnimation("idle")
    box.AnimState:SetMultColour(255/255,0/255,0/255,1)
    box.Transform:SetScale(0.5, 0.5, 0.5)
    local sound = box.entity:AddSoundEmitter()
    local minimap = box.entity:AddMiniMapEntity()
    minimap:SetIcon( "beebox.png" )
    box.components.inventoryitem:ChangeImageName("beebox")
    box:RemoveComponent("stackable")
    box:RemoveComponent("fuel")
    box:RemoveComponent("deployable")
    box:AddComponent("workable")
    box.components.workable:SetWorkAction(ACTIONS.HAMMER)
    box.components.workable:SetWorkLeft(3)
    box.components.workable:SetOnFinishCallback(function(box)
	 SpawnPrefab("collapse_small").Transform:SetPosition(box.Transform:GetWorldPosition())
	 box.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	 box:Remove()
    end )
    box.task = box:DoPeriodicTask(2, function(box)
        box.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
        box:DoTaskInTime(1, function() box.AnimState:SetBloomEffectHandle("") end )
        local pos = Vector3(box.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 30)
        for k,v in pairs(ents) do
            if v.components.health and not v.components.health:IsDead() and not v:HasTag("player") then
               if v.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == v or v:HasTag("monster") or v.prefab == "beefalo" or v.prefab == "bunnyman" or v.prefab == "pigman" or v.prefab == "pigguard" or v.prefab == "merm" or v.prefab == "monkey" or v.prefab == "tallbird" or v.prefab == "walrus" or v.prefab == "little_walrus" or v.prefab == "wasphive" then
                  local pt1 = box:GetPosition()
                  local killerbee = SpawnPrefab("nightmarefuel")
                  killerbee.Transform:SetPosition(pt1.x, pt1.y, pt1.z)
                  killerbee.AnimState:SetBank("bee")
                  killerbee.AnimState:SetBuild("bee_angry_build")
                  killerbee.AnimState:PlayAnimation("idle")
                  killerbee.AnimState:SetRayTestOnBB(true)
                  killerbee.AnimState:SetMultColour(255/255,255/255,255/255,1)
                  killerbee.entity:AddSoundEmitter()
                  killerbee.entity:AddLightWatcher()
                  killerbee.entity:AddDynamicShadow()
                  killerbee.DynamicShadow:SetSize( .8, .5 )
                  killerbee.Transform:SetFourFaced()
                  MakeCharacterPhysics(killerbee, 1, .3)
                  killerbee.Physics:SetCollisionGroup(COLLISION.FLYERS)
                  killerbee.Physics:ClearCollisionMask()
                  killerbee.Physics:CollidesWith(COLLISION.WORLD)
                  killerbee.Physics:CollidesWith(COLLISION.FLYERS)
                  killerbee:AddTag("killerbee")
                  killerbee:AddComponent("locomotor")
                  killerbee.components.locomotor:EnableGroundSpeedMultiplier(false)
                  killerbee.components.locomotor:SetTriggersCreep(false)
                  killerbee:SetStateGraph("SGbee")
                  killerbee:AddComponent("health")
                  killerbee.components.health:SetMaxHealth(200)
                  killerbee:AddComponent("combat")
                  killerbee.components.combat:SetTarget(v)
                  killerbee.components.combat:SetDefaultDamage(20)
                  killerbee.components.combat:SetAttackPeriod(0.1)
                  killerbee.components.combat.hiteffectsymbol = "body"
                  killerbee.components.combat:SetRetargetFunction(1, function(killerbee)
                      if not killerbee.components.health:IsDead() then
                         return FindEntity(box, 30, function(guy)
                             if guy.components.health and not guy.components.health:IsDead() and not guy:HasTag("player") then
                                return guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy or guy:HasTag("monster") or guy.prefab == "beefalo" or guy.prefab == "bunnyman" or guy.prefab == "pigman" or guy.prefab == "pigguard" or guy.prefab == "merm" or guy.prefab == "monkey" or guy.prefab == "tallbird" or guy.prefab == "walrus" or guy.prefab == "little_walrus" or guy.prefab == "wasphive"
                             end
                         end)
                      end
                  end )
                  local killerbrain = require("brains/killerbeebrain")
                  killerbee:SetBrain(killerbrain)
                  killerbee.sounds = killersounds
                  killerbee:AddComponent("knownlocations")
                  killerbee:ListenForEvent("attacked", function(killerbee, data) killerbee.components.combat:SetTarget(data.attacker) end )
                  killerbee:RemoveComponent("stackable")
                  killerbee:RemoveComponent("fuel")
                  killerbee:RemoveComponent("deployable")
                  killerbee:RemoveComponent("inventoryitem")
                  killerbee:DoTaskInTime(30, function() killerbee:Remove() end )
                  v:ListenForEvent("death", function() killerbee:Remove() end )
               end
            end
        end
    end )
    box.components.inventoryitem:SetOnPutInInventoryFn(function(box)
        box:RemoveTag("doings")
        if box.task then box.task:Cancel() box.task = nil end
        local pos = Vector3(box.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3000)
        for k,v in pairs(ents) do
            if v:HasTag("killerbee") then
               v:Remove()
            end
        end
    end )
    box.components.inventoryitem:SetOnDroppedFn(function(box)
        box:AddTag("doings")
        box.task = box:DoPeriodicTask(2, function(box)
            box.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
            box:DoTaskInTime(1, function() box.AnimState:SetBloomEffectHandle("") end )
            local pos = Vector3(box.Transform:GetWorldPosition())
            local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 30)
            for k,v in pairs(ents) do
                if v.components.health and not v.components.health:IsDead() and not v:HasTag("player") then
                   if v.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == v or v:HasTag("monster") or v.prefab == "beefalo" or v.prefab == "bunnyman" or v.prefab == "pigman" or v.prefab == "pigguard" or v.prefab == "merm" or v.prefab == "monkey" or v.prefab == "tallbird" or v.prefab == "walrus" or v.prefab == "little_walrus" or v.prefab == "wasphive" then
                      local pt1 = box:GetPosition()
                      local killerbee = SpawnPrefab("nightmarefuel")
                      killerbee.Transform:SetPosition(pt1.x, pt1.y, pt1.z)
                      killerbee.AnimState:SetBank("bee")
                      killerbee.AnimState:SetBuild("bee_angry_build")
                      killerbee.AnimState:PlayAnimation("idle")
                      killerbee.AnimState:SetRayTestOnBB(true)
                      killerbee.AnimState:SetMultColour(255/255,255/255,255/255,1)
                      killerbee.entity:AddSoundEmitter()
                      killerbee.entity:AddLightWatcher()
                      killerbee.entity:AddDynamicShadow()
                      killerbee.DynamicShadow:SetSize( .8, .5 )
                      killerbee.Transform:SetFourFaced()
                      MakeCharacterPhysics(killerbee, 1, .3)
                      killerbee.Physics:SetCollisionGroup(COLLISION.FLYERS)
                      killerbee.Physics:ClearCollisionMask()
                      killerbee.Physics:CollidesWith(COLLISION.WORLD)
                      killerbee.Physics:CollidesWith(COLLISION.FLYERS)
                      killerbee:AddTag("killerbee")
                      killerbee:AddComponent("locomotor")
                      killerbee.components.locomotor:EnableGroundSpeedMultiplier(false)
                      killerbee.components.locomotor:SetTriggersCreep(false)
                      killerbee:SetStateGraph("SGbee")
                      killerbee:AddComponent("health")
                      killerbee.components.health:SetMaxHealth(200)
                      killerbee:AddComponent("combat")
                      killerbee.components.combat:SetTarget(v)
                      killerbee.components.combat:SetDefaultDamage(20)
                      killerbee.components.combat:SetAttackPeriod(0.1)
                      killerbee.components.combat.hiteffectsymbol = "body"
                      killerbee.components.combat:SetRetargetFunction(1, function(killerbee)
                          if not killerbee.components.health:IsDead() then
                             return FindEntity(box, 30, function(guy)
                                 if guy.components.health and not guy.components.health:IsDead() and not guy:HasTag("player") then
                                    return guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy or guy:HasTag("monster") or guy.prefab == "beefalo" or guy.prefab == "bunnyman" or guy.prefab == "pigman" or guy.prefab == "pigguard" or guy.prefab == "merm" or guy.prefab == "monkey" or guy.prefab == "tallbird" or guy.prefab == "walrus" or guy.prefab == "little_walrus" or guy.prefab == "wasphive"
                                 end
                             end)
                          end
                      end )
                      local killerbrain = require("brains/killerbeebrain")
                      killerbee:SetBrain(killerbrain)
                      killerbee.sounds = killersounds
                      killerbee:AddComponent("knownlocations")
                      killerbee:ListenForEvent("attacked", function(killerbee, data) killerbee.components.combat:SetTarget(data.attacker) end )
                      killerbee:RemoveComponent("stackable")
                      killerbee:RemoveComponent("fuel")
                      killerbee:RemoveComponent("deployable")
                      killerbee:RemoveComponent("inventoryitem")
                      killerbee:DoTaskInTime(30, function() killerbee:Remove() end )
                      v:ListenForEvent("death", function() killerbee:Remove() end )
                   end
                end
            end
        end )
    end )
    box:AddTag("doings")
    box:AddTag("boxs")
  end
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
local function onsave(inst, data)
    if inst:HasTag("boxs") then
        data.boxs = true
    end
    if inst:HasTag("doings") then
        data.doings = true
    end
    if inst:HasTag("killerbee") then
        data.killerbee = true
    end
end
local function turnon(inst)
    inst.components.machine.ison = true
    inst:AddComponent("inventoryitem")
end
local function turnoff(inst)
    inst.components.machine.ison = false
    inst:RemoveComponent("inventoryitem")
end
    inst:AddComponent("machine")
    inst.components.machine.turnonfn = turnon
    inst.components.machine.turnofffn = turnoff
    inst:AddComponent("equippable")
local function onload(inst, data)
  if data and data.boxs then
     inst.AnimState:SetBank("bee_box")
     inst.AnimState:SetBuild("bee_box")
     inst.AnimState:PlayAnimation("idle")
     inst.AnimState:SetMultColour(255/255,0/255,0/255,1)
     inst.Transform:SetScale(0.5, 0.5, 0.5)
     local sound = inst.entity:AddSoundEmitter()
     local minimap = inst.entity:AddMiniMapEntity()
     minimap:SetIcon( "beebox.png" )
     inst.components.inventoryitem:ChangeImageName("beebox")
     inst:RemoveComponent("stackable")
     inst:RemoveComponent("fuel")
     inst:RemoveComponent("deployable")
     inst:AddComponent("workable")
     inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
     inst.components.workable:SetWorkLeft(3)
     inst.components.workable:SetOnFinishCallback(function(inst)
	  SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	  inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	  inst:Remove()
     end )
     inst.components.inventoryitem:SetOnPutInInventoryFn(function(inst)
         inst:RemoveTag("doings")
         if inst.task then inst.task:Cancel() inst.task = nil end
         local pos = Vector3(inst.Transform:GetWorldPosition())
         local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3000)
         for k,v in pairs(ents) do
             if v:HasTag("killerbee") then
                v:Remove()
             end
         end
     end )
     inst.components.inventoryitem:SetOnDroppedFn(function(inst)
         inst:AddTag("doings")
         inst.task = inst:DoPeriodicTask(2, function(inst)
             inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
             inst:DoTaskInTime(1, function() inst.AnimState:SetBloomEffectHandle("") end )
             local pos = Vector3(inst.Transform:GetWorldPosition())
             local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 30)
             for k,v in pairs(ents) do
                 if v.components.health and not v.components.health:IsDead() and not v:HasTag("player") then
                    if v.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == v or v:HasTag("monster") or v.prefab == "beefalo" or v.prefab == "bunnyman" or v.prefab == "pigman" or v.prefab == "pigguard" or v.prefab == "merm" or v.prefab == "monkey" or v.prefab == "tallbird" or v.prefab == "walrus" or v.prefab == "little_walrus" or v.prefab == "wasphive" then
                       local pt1 = inst:GetPosition()
                       local killerbee = SpawnPrefab("nightmarefuel")
                       killerbee.Transform:SetPosition(pt1.x, pt1.y, pt1.z)
                       killerbee.AnimState:SetBank("bee")
                       killerbee.AnimState:SetBuild("bee_angry_build")
                       killerbee.AnimState:PlayAnimation("idle")
                       killerbee.AnimState:SetRayTestOnBB(true)
                       killerbee.AnimState:SetMultColour(255/255,255/255,255/255,1)
                       killerbee.entity:AddSoundEmitter()
                       killerbee.entity:AddLightWatcher()
                       killerbee.entity:AddDynamicShadow()
                       killerbee.DynamicShadow:SetSize( .8, .5 )
                       killerbee.Transform:SetFourFaced()
                       MakeCharacterPhysics(killerbee, 1, .3)
                       killerbee.Physics:SetCollisionGroup(COLLISION.FLYERS)
                       killerbee.Physics:ClearCollisionMask()
                       killerbee.Physics:CollidesWith(COLLISION.WORLD)
                       killerbee.Physics:CollidesWith(COLLISION.FLYERS)
                       killerbee:AddTag("killerbee")
                       killerbee:AddComponent("locomotor")
                       killerbee.components.locomotor:EnableGroundSpeedMultiplier(false)
                       killerbee.components.locomotor:SetTriggersCreep(false)
                       killerbee:SetStateGraph("SGbee")
                       killerbee:AddComponent("health")
                       killerbee.components.health:SetMaxHealth(200)
                       killerbee:AddComponent("combat")
                       killerbee.components.combat:SetTarget(v)
                       killerbee.components.combat:SetDefaultDamage(20)
                       killerbee.components.combat:SetAttackPeriod(0.1)
                       killerbee.components.combat.hiteffectsymbol = "body"
                       killerbee.components.combat:SetRetargetFunction(1, function(killerbee)
                           if not killerbee.components.health:IsDead() then
                              return FindEntity(inst, 30, function(guy)
                                  if guy.components.health and not guy.components.health:IsDead() and not guy:HasTag("player") then
                                     return guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy or guy:HasTag("monster") or guy.prefab == "beefalo" or guy.prefab == "bunnyman" or guy.prefab == "pigman" or guy.prefab == "pigguard" or guy.prefab == "merm" or guy.prefab == "monkey" or guy.prefab == "tallbird" or guy.prefab == "walrus" or guy.prefab == "little_walrus" or guy.prefab == "wasphive"
                                  end
                              end)
                           end
                       end )
                       local killerbrain = require("brains/killerbeebrain")
                       killerbee:SetBrain(killerbrain)
                       killerbee.sounds = killersounds
                       killerbee:AddComponent("knownlocations")
                       killerbee:ListenForEvent("attacked", function(killerbee, data) killerbee.components.combat:SetTarget(data.attacker) end )
                       killerbee:RemoveComponent("stackable")
                       killerbee:RemoveComponent("fuel")
                       killerbee:RemoveComponent("deployable")
                       killerbee:RemoveComponent("inventoryitem")
                       killerbee:DoTaskInTime(30, function() killerbee:Remove() end )
                       v:ListenForEvent("death", function() killerbee:Remove() end )
                    end
                 end
             end
         end )
     end )
     inst:AddTag("boxs")
  end
  if data and data.doings then
     inst.task = inst:DoPeriodicTask(2, function(inst)
         inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
         inst:DoTaskInTime(1, function() inst.AnimState:SetBloomEffectHandle("") end )
         local pos = Vector3(inst.Transform:GetWorldPosition())
         local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 30)
         for k,v in pairs(ents) do
             if v.components.health and not v.components.health:IsDead() and not v:HasTag("player") then
                if v.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == v or v:HasTag("monster") or v.prefab == "beefalo" or v.prefab == "bunnyman" or v.prefab == "pigman" or v.prefab == "pigguard" or v.prefab == "merm" or v.prefab == "monkey" or v.prefab == "tallbird" or v.prefab == "walrus" or v.prefab == "little_walrus" or v.prefab == "wasphive" then
                   local pt1 = inst:GetPosition()
                   local killerbee = SpawnPrefab("nightmarefuel")
                   killerbee.Transform:SetPosition(pt1.x, pt1.y, pt1.z)
                   killerbee.AnimState:SetBank("bee")
                   killerbee.AnimState:SetBuild("bee_angry_build")
                   killerbee.AnimState:PlayAnimation("idle")
                   killerbee.AnimState:SetRayTestOnBB(true)
                   killerbee.AnimState:SetMultColour(255/255,255/255,255/255,1)
                   killerbee.entity:AddSoundEmitter()
                   killerbee.entity:AddLightWatcher()
                   killerbee.entity:AddDynamicShadow()
                   killerbee.DynamicShadow:SetSize( .8, .5 )
                   killerbee.Transform:SetFourFaced()
                   MakeCharacterPhysics(killerbee, 1, .3)
                   killerbee.Physics:SetCollisionGroup(COLLISION.FLYERS)
                   killerbee.Physics:ClearCollisionMask()
                   killerbee.Physics:CollidesWith(COLLISION.WORLD)
                   killerbee.Physics:CollidesWith(COLLISION.FLYERS)
                   killerbee:AddTag("killerbee")
                   killerbee:AddComponent("locomotor")
                   killerbee.components.locomotor:EnableGroundSpeedMultiplier(false)
                   killerbee.components.locomotor:SetTriggersCreep(false)
                   killerbee:SetStateGraph("SGbee")
                   killerbee:AddComponent("health")
                   killerbee.components.health:SetMaxHealth(200)
                   killerbee:AddComponent("combat")
                   killerbee.components.combat:SetTarget(v)
                   killerbee.components.combat:SetDefaultDamage(20)
                   killerbee.components.combat:SetAttackPeriod(0.1)
                   killerbee.components.combat.hiteffectsymbol = "body"
                   killerbee.components.combat:SetRetargetFunction(1, function(killerbee)
                       if not killerbee.components.health:IsDead() then
                          return FindEntity(inst, 30, function(guy)
                              if guy.components.health and not guy.components.health:IsDead() and not guy:HasTag("player") then
                                 return guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy or guy:HasTag("monster") or guy.prefab == "beefalo" or guy.prefab == "bunnyman" or guy.prefab == "pigman" or guy.prefab == "pigguard" or guy.prefab == "merm" or guy.prefab == "monkey" or guy.prefab == "tallbird" or guy.prefab == "walrus" or guy.prefab == "little_walrus" or guy.prefab == "wasphive"
                              end
                          end)
                       end
                   end )
                   local killerbrain = require("brains/killerbeebrain")
                   killerbee:SetBrain(killerbrain)
                   killerbee.sounds = killersounds
                   killerbee:AddComponent("knownlocations")
                   killerbee:ListenForEvent("attacked", function(killerbee, data) killerbee.components.combat:SetTarget(data.attacker) end )
                   killerbee:RemoveComponent("stackable")
                   killerbee:RemoveComponent("fuel")
                   killerbee:RemoveComponent("deployable")
                   killerbee:RemoveComponent("inventoryitem")
                   killerbee:DoTaskInTime(30, function() killerbee:Remove() end )
                   v:ListenForEvent("death", function() killerbee:Remove() end )
                end
             end
         end
     end )
     inst:AddTag("doings")
  end
  if data and data.killerbee then
     inst:Remove()
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload
    inst:AddComponent("fuel")
    inst.components.fuel.fueltype = "NIGHTMARE"
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL

    inst:AddComponent("inventoryitem")
    
	return inst
end

return Prefab( "common/inventory/nightmarefuel", fn, assets) 
