<?php

	/*******************************************************************\
	|																	|
	|	房佳（新房报备ERP管理系统）										|
	|																	|
	|	© 2020-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	// 分析枚举类型配置值 格式 a:名称1,b:名称2
	function parse_config_attr($string) {
		$array = preg_split('/[,;\r\n]+/', trim($string, ",;\r\n"));
		if(strpos($string,':')){
			$value = array();
			foreach ($array as $val) {
				list($k, $v) = explode(':', $val);
				$value[$k] = $v;
			}
		}else{
			$value = $array;
		}
		return $value;
	}

	/**
		* 格式化字节大小
		* @param number $size 字节数
		* @param string $delimiter 数字和单位分隔符
		* @return string 格式化后的带单位的大小
	*/

	function format_bytes($size, $delimiter = '') {
		$units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
		for ($i = 0; $size >= 1024 && $i < 5; $i++) $size /= 1024;
		return round($size, 2) . $delimiter . $units[$i];
	}

	//递归数组
	function node_merge($node, $access = null,$pid=0){
		$arr = array();
		foreach ($node as $v) {
			if (is_array($access)) {
				$v['access'] = in_array($v['id'],$access) ? 1 : 0;
			}
			if ($v['pid']==$pid) {
				$v['child'] = node_merge($node,$access,$v['id']);
				$arr[]=$v;
			}
		}
		return $arr;
	}

	/**
		* 获取客户端浏览器类型
		* @return string 浏览器类型返回字符串 unknown为未知浏览器类型
	*/

	function getBrowser(){
		$agent=$_SERVER["HTTP_USER_AGENT"];
		if(strpos($agent,'MSIE')!==false || strpos($agent,'rv:11.0')) //ie11判断
			return "ie";
		else if(strpos($agent,'Firefox')!==false)
			return "firefox";
		else if(strpos($agent,'Chrome')!==false)
			return "chrome";
		else if(strpos($agent,'Opera')!==false)
			return 'opera';
		else if((strpos($agent,'Chrome')==false)&&strpos($agent,'Safari')!==false)
			return 'safari';
		else
			return 'unknown';
	}

	/**
		* 上传文件类型控制 此方法仅限ajax上传使用
		* @param string $path 字符串 保存文件路径示例： /Upload/image/
		* @param string $format 文件格式限制
		* @param integer $maxSize 允许的上传文件最大值 52428800
		* @return booler 返回ajax的json格式数据
	*/

	//上传小区图片
	function ajax_upload_xq($path='file',$format='image',$maxSize='52428800'){
		ini_set('max_execution_time', '0');
		// 去除两边的/
		$path=trim($path,'/');
		// 添加Upload根目录
		$path=strtolower(substr($path, 0,6))==='upload' ? ucfirst($path) : 'Upload/'.$path;
		// 上传文件类型控制
		$ext_arr= array(
			'image' => array('gif', 'jpg', 'jpeg', 'png', 'bmp'),
			'photo' => array('jpg', 'jpeg', 'png'),
			'flash' => array('swf', 'flv'),
			'media' => array('swf', 'flv', 'mp3', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb'),
			'file' => array('doc', 'docx', 'xls', 'xlsx', 'ppt', 'htm', 'html', 'txt', 'zip', 'rar', 'gz', 'bz2','pdf')
		);
		if(!empty($_FILES)){
			// 上传文件配置
			$config=array(
				'maxSize' => $maxSize, // 上传文件最大为50M
				'rootPath' => './'.$path.'/', // 文件上传保存的根路径
				'savePath' => '', // 文件上传的保存路径（相对于根路径）
				'saveName' => array('uniqid',''), // 上传文件的保存规则，支持数组和字符串方式定义
				'autoSub' => false, // 自动使用子目录保存上传文件 默认为true
				'exts' => isset($ext_arr[$format])?$ext_arr[$format]:'',
			);
			// 实例化上传
			$upload=new \Think\Upload($config);
			// 调用上传方法
			$info=$upload->upload();
			$data=array();
			$Img = D('xqphoto');
			if(!$info){
				// 返回错误信息
				$error=$upload->getError();
				$data['error_info']=$error;
				echo json_encode($data);
			}else{
				// 返回成功信息
				foreach($info as $file){
					$file['savepath'] = "./Upload/".session('gongsiid')."/xiaoqu/".$_POST['xqid']."/";
					//上传的图片同步保存到数据库表
					$d['gongsiid'] = session('gongsiid');
					$d['uid'] = session('uid');
					$d['image'] = $file['savename'];
					$d['xqid'] = $_POST['xqid'];
					$d['create_time'] = time();
					$Img->add($d);
					//把xiaoqu表tupian字段更新为 1
					M('xiaoqu')->where(array('id'=>$_POST['xqid']))->setField('tupian',1);
					//为上传成功的图片生成缩略图
					$timg = new \Think\Image();
					$timg->open(trim($file['savepath'].$file['savename']));
					$newpathbig = trim($file['savepath']).'b_'.substr($file['savename'],0,strrpos($file['savename'], '.')).'.'.$file['ext'];
					$newpath = trim($file['savepath']).'t_'.substr($file['savename'],0,strrpos($file['savename'], '.')).'.'.$file['ext'];
					$timg->save($newpathbig); 
					$timg->thumb(450,450)->save($newpath);
					if (C('IS_PHOTO_JSY')==1) {
						// 给原图添加水印
						$timg->open($newpathbig)->water('./Upload/shuiyin/shuiyin.png',\Think\Image::IMAGE_WATER_CENTER,C('IS_PHOTO_TOUMING'))->save($newpathbig);
						$timg->open($newpath)->water('./Upload/shuiyin/shuiyin.png',\Think\Image::IMAGE_WATER_CENTER,C('IS_PHOTO_TOUMING'))->save($newpath);
					}
					//删除原图
					unlink('./Upload/'.session('gongsiid').'/xiaoqu/'.$_POST['xqid'].'/'.$file['savename']);
					rename($newpathbig,'./Upload/'.session('gongsiid').'/xiaoqu/'.$_POST['xqid'].'/'.$file['savename']);
					//返回给AJAX
					$data['name']=trim($file['savepath'].$file['savename'],'.');
					echo json_encode($data);
				}
			}
		}
	}

	//获取部门变动信息
	function get_xgbm($xiugaiqian,$xiugaihou,$bmming){
		$xgqian=M('bumen')->where(array('id'=>$xiugaiqian))->getField('bmming');
		$xghou=M('bumen')->where(array('id'=>$xiugaihou))->getField('bmming');
		return "部门：[".$xgqian."]=>[".$xghou."]；";
	}

	//获取岗位变动信息
	function get_xgjs($xiugaiqian,$xiugaihou,$remark){
		$xgqian=M('role')->where(array('id'=>$xiugaiqian))->getField('remark');
		$xghou=M('role')->where(array('id'=>$xiugaihou))->getField('remark');
		return "岗位：[".$xgqian."]=>[".$xghou."]；";
	}