<?php

    /*******************************************************************\
    |                                                                   |
    |   房佳（新房报备ERP管理系统）                                     |
    |                                                                   |
    |   © 2020-2023 http://www.kaidandashi.com/ All rights reserved.    |
    |                                                                   |
    |   本系统由淮南市银泰软件科技有限公司提供技术支持                  |
    |                                                                   |
    |   QQ号：984784483                                                 |
    |                                                                   |
    \*******************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    use QL\QueryList;
    class AjaxController extends CommonController {

        //获取报备楼盘
        public function get_bblp(){
            $condition = "e.gongsiid = '".session('gongsiid')."'";
            $x = _rbac_lists_where(963,0);
            if ($x && $x != "all" && $x != "me") {
                $condition .= " and e.bumen in ({$x})";
            } elseif ($x == "me") {
                $condition .= " and e.id = '".session('uid')."'";
            } elseif ($x == false) {
                $condition .= " and e.id = 0";
            }
            $txt = sql_check_param(I('txt'));
            if ($txt) {
                $condition .= " and (a.xiaoqum like '%$txt%' or a.pinyinjs like '%$txt%' or a.xiaoqubm like '%$txt%' or a.jiedao like '%$txt%' or a.xiaoqudz like '%$txt%' or e.ygmingcheng like '%$txt%' or e.pinyinjs like '%$txt%' or e.dianhua like '%$txt%')";
            }
            $xiaoqu = M('xiaoqu')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->field('a.id,a.xiaoqum')->where($condition)->order('id desc')->limit(10)->select();
            $data = array('status'=>1,'lists'=>$xiaoqu);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        // 我的报备
        public function wodekh(){
            $jindu = I('jindu',0,'int');
            $status = I('status',0,'int');
            if (I('is_ajax')) {
                $condition = "gongsiid = '".session('gongsiid')."' and whrid = '".session('uid')."'";
                $shijian = I('shijian');
                $sousuo = sql_check_param(I('sousuo'));
                if ($jindu) {
                    $condition .= " and jindu = '$jindu'";
                }
                if ($status) {
                    $condition .= " and status = '$status'";
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and addtime >= '".$time_s1."' and addtime < '".$time_s2."'";
                }
                if ($sousuo) {
                    $condition .= " and (bianhao like '%$sousuo%' or khxingming like '%$sousuo%' or dianhua like '%$sousuo%')";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $rzpx = $field." ".$order;
                } else {
                    $rzpx = "addtime desc";
                }
                $count = M('baobei')->where($condition)->count();
                $Page = I('p');
                $data = M('baobei')->where($condition)->order($rzpx)->page($Page,$limit)->select();
                foreach ($data as $key => $value) {
                    $zybh = explode("-", $value['bianhao']);
                    $data[$key]['zybh'] = $value['bianhao'] ? $value['bianhao'] : "——";
                    $data[$key]['bianhao'] = $zybh[1];
                    $khtype = get_peizhi('yezhulx',$value['khtype'],3);
                    $data[$key]['khxm'] = $value['khxingming'] ? $value['khxingming'].$khtype : "——";
                    $data[$key]['dianhua'] = $value['dianhua'] ? $value['dianhua'] : "——";
                    switch ($value['jindu']) {
                        case 1:
                            $jindu = "待审核";
                            break;
                        case 2:
                            $jindu = "已驳回";
                            break;
                        case 3:
                            $jindu = "待带看";
                            break;
                        case 4:
                            $jindu = "带看驳回";
                            break;
                        case 5:
                            $jindu = "待认筹";
                            break;
                        case 6:
                            $jindu = "认筹驳回";
                            break;
                        case 7:
                            $jindu = "待认购";
                            break;
                        case 8:
                            $jindu = "认购驳回";
                            break;
                        case 9:
                            $jindu = "待签约";
                            break;
                        case 10:
                            $jindu = "签约驳回";
                            break;
                        case 11:
                            $jindu = "待网签";
                            break;
                        case 12:
                            $jindu = "网签驳回";
                            break;
                        case 13:
                            $jindu = "待结佣";
                            break;
                        case 14:
                            $jindu = "结佣驳回";
                            break;
                        case 15:
                            $jindu = "已结佣";
                            break;
                        default:
                            $jindu = "——";
                            break;
                    }
                    $data[$key]['jindu'] = $jindu;
                    switch ($value['status']) {
                        case 1:
                            $status = "已通过";
                            break;
                        case 2:
                            $status = "已驳回";
                            break;
                        case 3:
                            $status = "待审核";
                            break;
                        default:
                            $status = "——";
                            break;
                    }
                    $data[$key]['status'] = $status;
                    $tjren = zym($value['adduid'],5);
                    $xiaoqum = zym($value['xiaoqu'],3);
                    $data[$key]['tjren'] = $tjren ? $tjren : "——";
                    $data[$key]['xiaoqum'] = $xiaoqum ? $xiaoqum : "——";
                    $data[$key]['remark'] = $value['remark'] ? $value['remark'] : "——";
                    $data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
                    $is_rbacxq = _rbac_btn_show(969,0,$value['whrid']);
                    $data[$key]['rbacxq'] = $is_rbacxq ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count,
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->jindu = $jindu;
                $this->status = $status;
                $this->display();
            }
        }

        //图片描述
        public function xqimgms(){
            $id = I('id',0,'int');
            if (IS_POST) {
                $uid = M('xqphoto')->where(array('id'=>$id))->getField('uid');
                $is_rbac = _rbac_btn_show(185,0,$uid);
                if (!$is_rbac) {
                    $this->redirect('Index/error');
                }
                $isok = M('xqphoto')->where(array("id"=>$id))->setField('remark',I('remark'));
                if ($isok) {
                    $this->success('更新成功');
                } else {
                    $this->error('更新失败');
                }
            } else {
                $this->id = $id;
                $this->display();
            }
        }

        //获取拼音检索
        public function get_pinyin(){
            $txt=I('txt');
            $py = new \Lib\Pinyin\Pinyin;
            $s = $py->qupinyin($txt ,true);
            $q = $py->qupinyin($txt);
            $h = $s.' '.$q.' '.$txt;
            $data=array('status'=>1,'pyjs'=>$h);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //获取未删除用户
        public function get_rsyonghu(){
            $txt=I('txt');
            $node=I('node');
            $x = _rbac_lists_where($node,0);
            if ($x && $x != "all" && $x != "me") {
                $map['bumen'] = array('in',$x);
            }elseif ($x == "me") {
                $map['id'] = session('uid');
            }elseif ($x == false) {
                $map['id'] = 0;
            }
            $map['status'] = 1;
            $map['gongsiid'] = session('gongsiid');
            $map['_string']='(pinyinjs like "%'.$txt.'%") or (ygmingcheng like "%'.$txt.'%") or (ygbianhao like "%'.$txt.'%") or (dianhua like "%'.$txt.'%")';
            $list=M('yonghu')->where($map)->field('id,ygmingcheng')->limit(10)->order('pinyinjs asc')->select();
            $data=array('status'=>1,'district'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //模糊查询小区
        public function get_baobeilp(){
            $condition = "e.gongsiid = '".session('gongsiid')."'";
            $x = _rbac_lists_where(966,0);
            if ($x && $x != "all" && $x != "me") {
                $condition .= " and e.bumen in ({$x})";
            } elseif ($x == "me") {
                $condition .= " and e.id = '".session('uid')."'";
            } elseif ($x == false) {
                $condition .= " and e.id = 0";
            }
            $sousuo = sql_check_param(I('txt'));
            if ($sousuo) {
                $condition .= " and (a.xiaoqum like '%$sousuo%' or a.pinyinjs like '%$sousuo%')";
            }
            $lists = M('xiaoqu')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->field('a.id,a.xiaoqum')->where($condition)->order('id desc')->limit(10)->select();
            $data=array('status'=>1,'lists'=>$lists);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        // 添加坐标
        public function addzb(){
            $zuobiao = I('zuobiao');
            if ($zuobiao) {
                $zb = $zuobiao;
                $this->isedit = 1;
            }else{
                $zb = $this->jcpz['dtzuobiao'];
            }
            $this->zb = $zb;
            $this->display();
        }

        /**
         * [get_xq_img 异步返回图片列表]
         * @return [json] [图片相关的数组]
         */
        public function get_xq_img(){
            $listObj = M('xqphoto');
            $where['p.xqid'] = I('xq_id');
            $list = $listObj->alias('p')->join(' jjrxt_yonghu as y on p.uid=y.id ')->field('p.id,p.leixing,p.leixing as lxming,p.fengmian,p.gongsiid,p.image,p.remark,FROM_UNIXTIME(p.create_time,"%Y-%m-%d") AS create_time,p.xqid,y.ygmingcheng')->where($where)->order('p.id desc')->select();
            if ($list) {
                $pzming='xqtplx';
            }
            foreach ($list as &$value) {
                $temp = get_peizhi($pzming,$value['leixing'],3);
                $value['lxming'] = $value['leixing']?$temp:'未设置图片类型';
                $value['remark'] = $value['remark']?$value['remark']:'暂无描述';
                $value['ms'] = _rbac_btn_show(185,0,$value['uid']) == true? '1': '0';
                $value['fm'] = _rbac_btn_show(485,0,$value['uid']) == true? '1': '0';
                $value['del']  = _rbac_btn_show(134,0,$value['uid']) == true? '1': '0';
            }
            //返回查询结果到异步json
            $data=array('pics'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //选择部门查询当前部门下的用户
        public function select_yuangong(){
            $id = I('id');
            $user = M('yonghu')->where(array('bumen'=>$id,'status'=>1))->field('id,ygmingcheng')->order('pinyinjs asc')->select();
            if($user){
                $this->ajaxReturn($user);
            }else{
                $this->ajaxReturn(array('status'=>0,'info'=>'当前部门下没有用户'));
            }
        }

        //查询当前行政区下的片区
        public function select_pianqu(){
            $id = I('xzqid');
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where(123,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $condition.=" and ssxzq=".$id;
            $list="select a.id,a.pianqum from (select id,pianqum,whrid,pinyinjs from __PIANQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc ";
            $Model = new \Think\Model;
            $pianqu=$Model->query($list);
            if($pianqu){
                $this->ajaxReturn($pianqu);
            }else{
                $this->ajaxReturn(array('status'=>0,'info'=>'当前行政区下没有片区'));
            }
        }

        //搜索行政区
        public function ss_xzq(){
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where(372,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $txt=I('txt');
            if ($txt) {
                $condition.=" and ((xzqming like '%$txt%') or (pinyinjs like '%$txt%'))";
            }
            $list="select a.id,a.xzqming from (select id,xzqming,whrid,pinyinjs from __XINGZHENGQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc limit 10 ";
            $Model = new \Think\Model;
            $xzq=$Model->query($list);
            $data=array('status'=>1,'lists'=>$xzq);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //搜索片区
        public function ss_pq(){
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where(123,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $txt=I('txt');
            if ($txt) {
                $condition.=" and ((pianqum like '%$txt%') or (pinyinjs like '%$txt%'))";
            }
            $list="select a.id,a.pianqum from (select id,pianqum,whrid,pinyinjs from __PIANQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc limit 10 ";
            $Model = new \Think\Model;
            $pq=$Model->query($list);
            $data=array('status'=>1,'lists'=>$pq);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //搜索小区
        public function ss_xq(){
            $node = I('node');
            switch ($node) {
                case 129:
                    $node = 129;
                    break;
                case 963:
                    $node = 963;
                    break;
                default:
                    $node = 129;
                    break;
            }
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where($node,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $txt=I('txt');
            if ($txt) {
                $condition.=" and ((xiaoqum like '%$txt%') or (pinyinjs like '%$txt%'))";
            }
            $list="select a.id,a.xiaoqum from (select id,xiaoqum,whrid,pinyinjs from __XIAOQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc limit 10 ";
            $Model = new \Think\Model;
            $xq=$Model->query($list);
            $data=array('status'=>1,'lists'=>$xq);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        /**
            * 获取递归数组深度
            * @param $id
            * @param $array
            * @param $i
        */
        public function get_level($id, $array = array(), $i = 0) {
            if ($array[$id]['parentid']==0 || empty($array[$array[$id]['parentid']]) || $array[$id]['parentid']==$id){
                return  $i;
            }else{
                $i++;
                return $this->get_level($array[$id]['parentid'],$array,$i);
            }
        }

        public function bbsh(){
            ini_set('max_execution_time', '0');
            $admin_id = M("yonghu")->where(array('dianhua'=>C("RBAC_SUPERADMIN")))->getField('id');
            $baobei = M("baobei")->where(array('status'=>3))->field('id,bianhao,xiaoqu,addtime')->select();
            foreach ($baobei as $key => $value) {
                $bbbhq = M("xiaoqu")->where(array('id'=>$value['xiaoqu']))->getField('baobei');
                $zhsx = $value['addtime']+($bbbhq*86400);
                if (time() > $zhsx) {
                    $data_baobei['jindu'] = 2;
                    $data_baobei['status'] = 2;
                    M("baobei")->where(array('id'=>$value['id']))->save($data_baobei);
                    $shenhe = M('shenhe')->where(array('type'=>1,'zyid'=>$value['id']))->field('id,adduid')->find();
                    $data_shenhe['status'] = 2;
                    $data_shenhe['remark'] = "超过报备保护期未审核，系统自动驳回。";
                    $data_shenhe['shijian'] = time();
                    $data_shenhe['uid'] = $admin_id;
                    M('shenhe')->where(array('id'=>$shenhe['id']))->save($data_shenhe);
                    $xiugai = "超过报备保护期未审核，系统自动驳回了".zym($shenhe['adduid'],5)."提交的".$value['bianhao']."报备申请。";
                    $data_rizhi['zy_type'] = 4;
                    $data_rizhi['uid'] = $admin_id;
                    $data_rizhi['addtime'] = time();
                    $data_rizhi['cz_type'] = 18;
                    $data_rizhi['zy_id'] = $shenhe['id'];
                    $data_rizhi['zy_bianhao'] = $value['bianhao'];
                    $data_rizhi['neirong'] = $xiugai;
                    M('rizhi')->add($data_rizhi);
                }
            }
            $this->dksh();
        }

    }