<?php

	/*******************************************************************\
	|																	|
	|	房佳（新房报备ERP管理系统）										|
	|																	|
	|	© 2020-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	namespace Admin\Controller;
	use Think\Controller;
	class BaobeiController extends CommonController {

		// 报备列表
		public function index(){
			if (I('is_ajax')) {
				$condition = "e.gongsiid = '".session('gongsiid')."'";
				$x = _rbac_lists_where(968,0);
				if ($x && $x != "all" && $x != "me") {
					$condition .= " and e.bumen in ({$x})";
				} elseif ($x == "me") {
					$condition .= " and e.id = '".session('uid')."'";
				} elseif ($x == false) {
					$condition .= " and e.id = 0";
				}
				$shijian = I('shijian');
				$bumen = I('bumen',0,'int');
				$jindu = I('jindu',0,'int');
				$status = I('status',0,'int');
				$sousuo = sql_check_param(I('sousuo'));
				if ($bumen) {
					$string = get_bm_sz($bumen,2);
					$condition .= " and e.bumen in ($string)";
				}
				if ($jindu) {
					$condition .= " and a.jindu = '$jindu'";
				}
				if ($status) {
					$condition .= " and a.status = '$status'";
				}
				if ($shijian) {
					$time_s = explode(' - ',$shijian);
					$time_s1 = strtotime($time_s[0]);
					$time_s2 = strtotime($time_s[1])+86400;
					$condition .= " and a.addtime >= '".$time_s1."' and a.addtime < '".$time_s2."'";
				}
				if ($sousuo) {
					$condition .= " and (a.bianhao like '%$sousuo%' or a.khxingming like '%$sousuo%' or a.dianhua like '%$sousuo%' or e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%')";
				}
				$field = I('field'); //排序字段名
				$order = I('order'); //排序方式
				$limit = I('limit',30,'int'); //每页条数
				$limit = $limit > 150 ? 150 : $limit;
				if ($field && $order) {
					$rzpx = "a.".$field." ".$order;
				} else {
					$rzpx = "a.id desc";
				}
				$count = M('baobei')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->where($condition)->count();
				$Page = I('p');
				$data = M('baobei')->alias('a')->join('jjrxt_yonghu e on a.whrid=e.id')->field('a.*,e.ygmingcheng')->where($condition)->order($rzpx)->page($Page,$limit)->select();
				foreach ($data as $key => $value) {
					$zybh = explode("-", $value['bianhao']);
					$data[$key]['zybh'] = $value['bianhao'] ? $value['bianhao'] : "——";
					$data[$key]['bianhao'] = $zybh[1];
					$khtype = get_peizhi('yezhulx',$value['khtype'],3);
					$data[$key]['khxm'] = $value['khxingming'] ? $value['khxingming'].$khtype : "——";
					$data[$key]['dianhua'] = $value['dianhua'] ? $value['dianhua'] : "——";
					switch ($value['jindu']) {
						case 1:
							$jindu = "待审核";
							break;
						case 2:
							$jindu = "已驳回";
							break;
						case 3:
							$jindu = "待带看";
							break;
						case 4:
							$jindu = "带看驳回";
							break;
						case 5:
							$jindu = "待认筹";
							break;
						case 6:
							$jindu = "认筹驳回";
							break;
						case 7:
							$jindu = "待认购";
							break;
						case 8:
							$jindu = "认购驳回";
							break;
						case 9:
							$jindu = "待签约";
							break;
						case 10:
							$jindu = "签约驳回";
							break;
						case 11:
							$jindu = "待网签";
							break;
						case 12:
							$jindu = "网签驳回";
							break;
						case 13:
							$jindu = "待结佣";
							break;
						case 14:
							$jindu = "结佣驳回";
							break;
						case 15:
							$jindu = "已结佣";
							break;
						default:
							$jindu = "——";
							break;
					}
					$data[$key]['jindu'] = $jindu;
					switch ($value['status']) {
						case 1:
							$status = "已通过";
							break;
						case 2:
							$status = "已驳回";
							break;
						case 3:
							$status = "待审核";
							break;
						default:
							$status = "——";
							break;
					}
					$data[$key]['status'] = $status;
					$tjren = zym($value['adduid'],5);
					$xiaoqum = zym($value['xiaoqu'],3);
					$data[$key]['tjren'] = $tjren ? $tjren : "——";
					$data[$key]['xiaoqum'] = $xiaoqum ? $xiaoqum : "——";
					$data[$key]['whren'] = $value['ygmingcheng'] ? $value['ygmingcheng'] : "——";
					$data[$key]['remark'] = $value['remark'] ? $value['remark'] : "——";
					$data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
					$is_rbacxq = _rbac_btn_show(969,0,$value['whrid']);
					$data[$key]['rbacxq'] = $is_rbacxq ? 1 : 0;
				}
				$return_data = array(
					'code'=>0,
					'count'=>$count,
					'data'=>$data
				);
				$this->ajaxReturn($return_data);
			} else {
				$select_categorys = bumen_option($bumen,968);
				$this->assign("select_categorys",$select_categorys);
				$this->display();
			}
		}

		// 报备内容
		public function neirong(){
			$id = I('id',0,'int');
			$bianhao = I('bianhao');
			if ($id) {
				$baobei = M('baobei')->where(array('id'=>$id))->find();
			} elseif ($bianhao) {
				$baobei = M('baobei')->where(array('bianhao'=>$bianhao))->find();
			}
			$is_rbac = _rbac_btn_show(969,0,$baobei['whrid']);
			if (!$is_rbac) {
				$this->redirect('Index/error');
			}
			switch ($baobei['jindu']) {
				case 1:
					$jindu = "待审核";
					break;
				case 2:
					$jindu = "已驳回";
					break;
				case 3:
					$jindu = "待带看";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					$is_rbacdk = _rbac_btn_show(971,0,$baobei['whrid']);
					break;
				case 4:
					$jindu = "带看驳回";
					break;
				case 5:
					$jindu = "待认筹";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					$is_rbacdk = _rbac_btn_show(971,0,$baobei['whrid']);
					$is_rbacrc = _rbac_btn_show(974,0,$baobei['whrid']);
					$is_rbacrg = _rbac_btn_show(976,0,$baobei['whrid']);
					break;
				case 6:
					$jindu = "认筹驳回";
					break;
				case 7:
					$jindu = "待认购";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					$is_rbacdk = _rbac_btn_show(971,0,$baobei['whrid']);
					$is_rbacrg = _rbac_btn_show(976,0,$baobei['whrid']);
					break;
				case 8:
					$jindu = "认购驳回";
					break;
				case 9:
					$jindu = "待签约";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					$is_rbacdk = _rbac_btn_show(971,0,$baobei['whrid']);
					$is_rbacqy = _rbac_btn_show(978,0,$baobei['whrid']);
					break;
				case 10:
					$jindu = "签约驳回";
					break;
				case 11:
					$jindu = "待网签";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					$is_rbacdk = _rbac_btn_show(971,0,$baobei['whrid']);
					$is_rbacwq = _rbac_btn_show(980,0,$baobei['whrid']);
					break;
				case 12:
					$jindu = "网签驳回";
					break;
				case 13:
					$jindu = "待结佣";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					$is_rbacjy = _rbac_btn_show(982,0,$baobei['whrid']);
					break;
				case 14:
					$jindu = "结佣驳回";
					break;
				case 15:
					$jindu = "已结佣";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					break;
				default:
					$jindu = "暂无信息";
					break;
			}
			$baobei['jindu'] = $jindu;
			$is_rbacsh = "";
			$shenhe = M('shenhe')->where(array('zyid'=>$baobei['id'],'type'=>1))->field('id,status')->find();
			$baobei['shid'] = $shenhe['id'] ? $shenhe['id'] : 0;
			switch ($shenhe['status']) {
				case 1:
					$status = "已通过";
					$is_rbacfk = _rbac_btn_show(1044,0,$xiaoqu['whrid']);
					break;
				case 2:
					$status = "已驳回";
					break;
				case 3:
					$status = "待审核";
					$is_rbacsh = _rbac_btn_show(972,0,$value['uid']);
					break;
				default:
					$status = "暂无信息";
					break;
			}
			$baobei['status'] = $status;
			$khtype = get_peizhi('yezhulx',$baobei['khtype'],3);
			$khxingming = $baobei['khxingming'] ? $baobei['khxingming'].$khtype : "暂无信息";
			$baobei['khxingming'] = $khxingming;
			$baobei['dianhua'] = $baobei['dianhua'] ? $baobei['dianhua'] : "暂无信息";
			$baobei['remark'] = $baobei['remark'] ? $baobei['remark'] : "暂无信息";
			$tjrxx = M('yonghu')->where(array('id'=>$baobei['adduid']))->field('ygmingcheng,dianhua')->find();
			$baobei['tjren'] = $tjrxx['ygmingcheng'] ? $tjrxx['ygmingcheng'] : "暂无信息";
			$baobei['tjrdh'] = $tjrxx['dianhua'] ? $tjrxx['dianhua'] : "暂无信息";
			$whrxx = M('yonghu')->where(array('id'=>$baobei['whrid']))->field('ygmingcheng,dianhua')->find();
			$baobei['whren'] = $whrxx['ygmingcheng'] ? $whrxx['ygmingcheng'] : "暂无信息";
			$baobei['whrdh'] = $whrxx['dianhua'] ? $whrxx['dianhua'] : "暂无信息";
			$xiaoqu = M('xiaoqu')->where(array('id'=>$baobei['xiaoqu']))->field('xiaoqum,whrid,daikangz')->find();
			$baobei['xiaoqum'] = $xiaoqu['xiaoqum'] ? $xiaoqu['xiaoqum'] : "暂无信息";
			$baobei['daikangz'] = $xiaoqu['daikangz'] ? $xiaoqu['daikangz'] : "暂无信息";
			$baobei['yjdfsj'] = $baobei['yjdfsj'] ? date('Y-m-d H:i:s',$baobei['yjdfsj']) : "暂无信息";
			$baobei['addtime'] = $baobei['addtime'] ? date('Y-m-d H:i:s',$baobei['addtime']) : "暂无信息";
			$baobei['dizhi'] = $dizhi ? $dizhi : "暂无信息";
			$baobei['qrdks'] = $qrdks ? $qrdks : 0;
			$is_rbaczd = _rbac_btn_show(965,0,$xiaoqu['whrid']);
			$is_rbacxq = _rbac_btn_show(964,0,$xiaoqu['whrid']);
			$baobei['rbacdk'] = $is_rbacdk ? 1 : 0;
			$baobei['rbacrc'] = $is_rbacrc ? 1 : 0;
			$baobei['rbacrg'] = $is_rbacrg ? 1 : 0;
			$baobei['rbacqy'] = $is_rbacqy ? 1 : 0;
			$baobei['rbacwq'] = $is_rbacwq ? 1 : 0;
			$baobei['rbacjy'] = $is_rbacjy ? 1 : 0;
			$baobei['rbacfk'] = $is_rbacfk ? 1 : 0;
			$baobei['rbacsh'] = $is_rbacsh ? 1 : 0;
			$baobei['rbaczd'] = $is_rbaczd ? 1 : 0;
			$baobei['rbacxq'] = $is_rbacxq ? 1 : 0;
			$this->baobei = $baobei;
			$rizhi = M('rizhi')->where(array('zy_type'=>4,'zy_bianhao'=>$baobei['bianhao']))->order('id desc')->select();
			foreach ($rizhi as $key => $value) {
				$rizhi[$key]['uid'] = zym($value['uid'],5);
				$rizhi[$key]['addtime'] = date('Y-m-d H:i:s',$value['addtime']);
				switch ($value['cz_type']) {
					case 1:
						$cz_type = "新增";
						break;
					case 12:
						$cz_type = "上传图片";
						break;
					case 17:
						$cz_type = "写带看";
						break;
					case 18:
						$cz_type = "审核";
						break;
					case 32:
						$cz_type = "认筹";
						break;
					case 33:
						$cz_type = "认购";
						break;
					case 34:
						$cz_type = "签约";
						break;
					case 35:
						$cz_type = "网签";
						break;
					case 36:
						$cz_type = "结佣";
						break;
					case 37:
						$cz_type = "驻场反馈";
						break;
					default:
						$cz_type = "——";
						break;
				}
				$rizhi[$key]['cz_type'] = $cz_type;
				$rizhi[$key]['neirong'] = $value['neirong'] ? $value['neirong'] : "——";
			}
			$this->rizhi = $rizhi;
			$this->display();
		}

		// 报备日志
		public function rizhi(){
			if (I('is_ajax')) {
				$condition = "e.gongsiid = '".session('gongsiid')."' and a.zy_type = 4";
				$x = _rbac_lists_where(984,0);
				if ($x && $x != "all" && $x != "me") {
					$condition .= " and e.bumen in ({$x})";
				} elseif ($x == "me") {
					$condition .= " and e.id = '".session('uid')."'";
				} elseif ($x == false) {
					$condition .= " and e.id = 0";
				}
				$shijian = I('shijian');
				$bumen = I('bumen',0,'int');
				$sousuo = sql_check_param(I('sousuo'));
				if ($bumen) {
					$string = get_bm_sz($bumen,2);
					$condition .= " and e.bumen in ($string)";
				}
				if ($shijian) {
					$time_s = explode(' - ',$shijian);
					$time_s1 = strtotime($time_s[0]);
					$time_s2 = strtotime($time_s[1])+86400;
					$condition .= " and a.addtime >= '".$time_s1."' and a.addtime < '".$time_s2."'";
				}
				if ($sousuo) {
					$condition .= " and (e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%' or a.zy_bianhao like '%$sousuo%')";
				}
				$field = I('field'); //排序字段名
				$order = I('order'); //排序方式
				$limit = I('limit',30,'int'); //每页条数
				$limit = $limit > 150 ? 150 : $limit;
				if ($field && $order) {
					$rzpx = "a.".$field." ".$order;
				} else {
					$rzpx = "a.addtime desc";
				}
				$count = M('rizhi')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->where($condition)->count();
				$Page = I('p');
				$data = M('rizhi')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen')->where($condition)->order($rzpx)->page($Page,$limit)->select();
				foreach ($data as $key => $value) {
					$data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
					$bmming = zym($value['bumen'],6);
					$data[$key]['bmming'] = $bmming ? $bmming : "——";
					$zybh = explode("-", $value['zy_bianhao']);
					$data[$key]['zybh'] = $value['zy_bianhao'] ? $value['zy_bianhao'] : "——";
					$data[$key]['zy_bianhao'] = $zybh[1];
					$data[$key]['zylx'] = "报备";
					switch ($value['cz_type']) {
						case 1:
							$cz_type = "新增";
							break;
						case 12:
							$cz_type = "上传图片";
							break;
						case 17:
							$cz_type = "写带看";
							break;
						case 18:
							$cz_type = "审核";
							break;
						case 32:
							$cz_type = "认筹";
							break;
						case 33:
							$cz_type = "认购";
							break;
						case 34:
							$cz_type = "签约";
							break;
						case 35:
							$cz_type = "网签";
							break;
						case 36:
							$cz_type = "结佣";
							break;
						case 37:
							$cz_type = "驻场反馈";
							break;
						default:
							$cz_type = "——";
							break;
					}
					$data[$key]['cz_type'] = $cz_type;
					$data[$key]['neirong'] = $value['neirong'] ? $value['neirong'] : "——";
				}
				$return_data = array(
					'code'=>0,
					'count'=>$count,
					'data'=>$data
				);
				$this->ajaxReturn($return_data);
			} else {
				$select_categorys = bumen_option($bumen,984);
				$this->assign("select_categorys",$select_categorys);
				$this->display();
			}
		}

	}