<?php

	/*******************************************************************\
	|																	|
	|	房佳（新房报备ERP管理系统）										|
	|																	|
	|	© 2020-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	namespace Admin\Controller;
	use Think\Controller;
	use Common\Controller\BaseController;
	class LoginController extends BaseController {
		Public function _initialize(){
			parent::_initialize();
			if (ismobile()) {
				//设置默认默认主题为 Mobile
                $mobile = get_img_url("/mobile");
                redirect($mobile);die;
			}
			/* 读取数据库中的配置 */
			$config = S('DB_CONFIG_DATA');
			if(!$config){
				$config = lists();
				S('DB_CONFIG_DATA',$config);
			}
			C($config); //添加配置
		}
		public function index(){
			$this->display(); 
		}
		//自动提交检测加密锁是否已注册
		public function regist(){
			//设置默认主题为 Mobile
			if (ismobile()) {
				C('DEFAULT_THEME','Mobile');
				$this->redirect('Login/index');
			}else{
				if (IS_POST) {
					$Yh = M('Yonghu');
					$k = $Yh->where(array('keyid' =>I('KeyID'),'gongsiid'=>I('gongsiid')))->field('keyid')->find();
					if ($k) {
						$Mac = M('Mac');
						$m = $Mac->where(array('macid'=>I('MacID')))->field('macid,shenhe')->find();
						if ($m['shenhe']==1) {
							$this->redirect('Login/index'); 
						}elseif(!is_null($m['macid']) && is_null($m['shenhe'])){
							$this->redirect('Login/setmac?sh=1'); 
						}else{
							//申请mac地址注册
							$this->redirect('Login/setmac'); 
						}
					}else{
						//当前加密key未注册
						$this->redirect('Login/setmac');
					}
				}
				$this->display();
			}
		}
		//注册mac地址
		public function setmac(){
		if (IS_POST) {
				$xm = trim(I('xm'));
				$phone = trim(I('phone'));
				$bm = trim(I('bm'));
				$dnbh = trim(I('dnbh'));
				if ($xm=='' || $phone=='' || $bm=='' || $dnbh=='') {
					$this->redirect('Login/setmac?err=1');	//姓名、手机号、部门、电脑编号不可以为空。 
				}
				$Yh = M('Yonghu');
				$k = $Yh->where(array('keyid' =>I('KeyID'),'gongsiid'=>I('gongsiid')))->field('keyid')->find();
				if ($k) {
					if(M('Mac')->where(array('macid'=>I('MacID'),'shenhe'=>1))->getField('id')) $this->redirect('Login/index');
					if(M('Mac')->where(array('macid'=>I('MacID')))->getField('id')) $this->error('申请审核中，请等候管理员通知！'); 
					if(substr(I('MacID'),0,5)=='00-50') $this->error('MAC地址为虚拟机地址，请禁用虚拟机网卡！');
					$Mac = M('Mac');
					$data['macid'] = I('MacID');
					$data['keyid'] = I('KeyID');
					$data['xm'] = $xm;
					$data['phone'] = $phone;
					$data['bm'] = zym($bm,6);
					$data['dnbh'] = $dnbh;
					$data['beizhu'] = I('beizhu');
					$data['tjsj'] = time();
					$m = $Mac->add($data);
					if ($m) {
						$this->redirect('Login/regist'); 
					}else{
						$this->error('申请失败！'); 
					}
				}else{
					//当前加密key未注册
					$this->redirect('Login/404'); 
				}
			}else{
				//输出部门option
				$bumen = $user['bumen'];
				$select_categorys = bumen_option( $bumen, 0);
				$this->assign("select_categorys", $select_categorys);
				$this->display();
			}
		}
		public function VerifyImg(){
			$verify = new \Think\Verify();
			//$verify->useZh = true;  //使用中文验证码
			$verify->fontSize = 35; //验证码字体大小
			$verify->useNoise = false;  //关闭验证码干扰项
			$verify->length = 2; 
			$verify->imageW = 220;
			$verify->imageH= 70;
			ob_end_clean();
			$verify->entry();
		}
		public function Login(){
			if (!IS_POST)$this->error('页面不存在');
			//加密锁验证
			if (C('IS_LOGIN_KEY')==1 && !ismobile()) {
				$keyid = I('KeyID');
				$macid = I('MacID');
				$yhdianhua = M('yonghu')->where(array('keyid'=>$keyid,'gongsiid'=>I('gongsiid')))->getField('dianhua');
				if (!$keyid) {
					$this->error('请插入加密锁！','index');
				}
				if ($yhdianhua == C('RBAC_SUPERADMIN')) {
					$userkeyid=M('Yonghu')->where(array('dianhua' =>I('username'),'gongsiid'=>I('gongsiid')))->getField('keyid');
					if ($userkeyid != $keyid) {
						$this->error('加密锁与账号不匹配。','index');
					}
				} else {
					$r = M('Mac')->where(array('macid' =>$macid,'shenhe'=>1))->find();
					if(!$r) $this->error('当前业务主机未注册！','setmac');
					$userkeyid=M('Yonghu')->where(array('dianhua' =>I('username'),'gongsiid'=>I('gongsiid')))->getField('keyid');
					if ($userkeyid != $keyid) {
						$this->error('加密锁与账号不匹配。','index');
					}
				}
			}
			//验证码判断
			if (C('IS_LOGIN_VERIFY')==1) {
				$verify = new \Think\Verify();
				$code= trim(I('yzm'));
				if($verify->check($code) === false){
					$this->error('验证码错误');
				}
			}
			$db=M('yonghu');
			if(I('username') != C('RBAC_SUPERADMIN')){
				$gongsi=$db->where(array('gongsiid' =>I('gongsiid')))->find();
				if (!$gongsi) {
					$this->error('公司账号错误');
				}
			}
			$user=$db->where(array('dianhua' =>I('username'),'gongsiid'=>I('gongsiid')))->find();
			if (!$user || $user['mima'] != I('password','','md5')) {
				$this->error('账号或密码错误');
			}
			if ($user['lock1']==1) {
				$this->error('账号已被停用');
			}
			if ($user['status']==0) {
				$this->error('账号或密码错误');
			}
			$ipdz=get_client_ip();
			// $wldz = findCityByIp($ipdz);
			// if ($wldz) {
			// 	$zsdz=$wldz;
			// } else {
			// 	$zsdz='未知';
			// }
			$data = array(
				'id'=>$user['id'],
				'logintime'=>time(),
				'loginip'=>$ipdz
			);
			$db->save($data);
			$data1 = array(
				'shijian'=>time(),
				'ipdizhi'=>$ipdz,
				// 'zdbianhao'=>$zsdz,
				'yonghu'=>$user['ygmingcheng'],
				'uid'=>$user['id'],
				'bumen'=>$user['bumen'],
				'dlleibie'=>'PC端',
			);
			M('dlrizhi')->add($data1);
			$role_id=M('role_user')->where(array('user_id' =>$user['id']))->getField('role_id');
			session('uid',$user['id']);
			session('role',$role_id);
			session('bumen',$user['bumen']);
			session('ygmingcheng',$user['ygmingcheng']);
			session('gongsiid',$user['gongsiid']);
			session('username',$user['dianhua']);
			session('logintime',date('Y-m-d H:i:s',$user['logintime']));
			session('loginip',$user['loginip']);
			if($user['dianhua'] == C('RBAC_SUPERADMIN')){
				session(C('ADMIN_AUTH_KEY'),true);
			}
			\Org\Util\Rbac::saveAccessList();
			$this->success('登录成功','Index/index');
		}
		public function Logout(){
			session_unset();
			session_destroy();
			$this->redirect('Login/index');
		}
        public function bbsh(){
            ini_set('max_execution_time', '0');
            $admin_id = M("yonghu")->where(array('dianhua'=>C("RBAC_SUPERADMIN")))->getField('id');
            $baobei = M("baobei")->where(array('status'=>3))->field('id,bianhao,xiaoqu,addtime')->select();
            foreach ($baobei as $key => $value) {
                $bbbhq = M("xiaoqu")->where(array('id'=>$value['xiaoqu']))->getField('baobei');
                $zhsx = $value['addtime']+($bbbhq*86400);
                if (time() > $zhsx) {
                    $data_baobei['jindu'] = 2;
                    $data_baobei['status'] = 2;
                    M("baobei")->where(array('id'=>$value['id']))->save($data_baobei);
                    $shenhe = M('shenhe')->where(array('type'=>1,'zyid'=>$value['id']))->field('id,adduid')->find();
                    $data_shenhe['status'] = 2;
                    $data_shenhe['remark'] = "超过报备保护期未审核，系统自动驳回。";
                    $data_shenhe['shijian'] = time();
                    $data_shenhe['uid'] = $admin_id;
                    M('shenhe')->where(array('id'=>$shenhe['id']))->save($data_shenhe);
                    $xiugai = "超过报备保护期未审核，系统自动驳回了".zym($shenhe['adduid'],5)."提交的".$value['bianhao']."报备申请。";
                    $data_rizhi['zy_type'] = 4;
                    $data_rizhi['uid'] = $admin_id;
                    $data_rizhi['addtime'] = time();
                    $data_rizhi['cz_type'] = 18;
                    $data_rizhi['zy_id'] = $shenhe['id'];
                    $data_rizhi['zy_bianhao'] = $value['bianhao'];
                    $data_rizhi['neirong'] = $xiugai;
                    M('rizhi')->add($data_rizhi);
                }
            }
            $this->dksh();
        }
        public function dksh(){
            ini_set('max_execution_time', '0');
            $admin_id = M("yonghu")->where(array('dianhua'=>C("RBAC_SUPERADMIN")))->getField('id');
            $daikan = M("daikan")->where(array('status'=>3))->field('id,zybh,xqid,addtime')->select();
            foreach ($daikan as $key => $value) {
                $dkbhq = M("xiaoqu")->where(array('id'=>$value['xqid']))->getField('daikan');
                $zhsx = $value['addtime']+($dkbhq*86400);
                if (time() > $zhsx) {
                    M("daikan")->where(array('id'=>$value['id']))->setField('status',2);
                    $shenhe = M('shenhe')->where(array('type'=>2,'zyid'=>$value['id']))->field('id,adduid')->find();
                    $data_shenhe['status'] = 2;
                    $data_shenhe['remark'] = "超过带看保护期未审核，系统自动驳回。";
                    $data_shenhe['shijian'] = time();
                    $data_shenhe['uid'] = $admin_id;
                    M('shenhe')->where(array('id'=>$shenhe['id']))->save($data_shenhe);
                    $xiugai = "超过带看保护期未审核，系统自动驳回了".zym($shenhe['adduid'],5)."提交的".$value['zybh']."带看申请。";
                    $data_rizhi['zy_type'] = 4;
                    $data_rizhi['uid'] = $admin_id;
                    $data_rizhi['addtime'] = time();
                    $data_rizhi['cz_type'] = 18;
                    $data_rizhi['zy_id'] = $shenhe['id'];
                    $data_rizhi['zy_bianhao'] = $value['zybh'];
                    $data_rizhi['neirong'] = $xiugai;
                    M('rizhi')->add($data_rizhi);
                }
            }
            $this->bbdk();
        }
        public function bbdk(){
            ini_set('max_execution_time', '0');
            $admin_id = M("yonghu")->where(array('dianhua'=>C("RBAC_SUPERADMIN")))->getField('id');
            $baobei = M("baobei")->where(array('jindu'=>3))->field('id,bianhao,xiaoqu,adduid,addtime')->select();
            foreach ($baobei as $key => $value) {
                $isdk = M('daikan')->where(array('zyid'=>$value['id']))->count();
                if ($isdk > 0) {
                    $addtime = M('daikan')->where(array('zyid'=>$value['id']))->order('addtime asc')->limit(1)->getField('addtime');
                    $dkbhq = M("xiaoqu")->where(array('id'=>$value['xiaoqu']))->getField('daikan');
                    $zhsx = $addtime+($dkbhq*86400);
                    $remark = "报备".$value['bianhao']."超过带看保护期无审核通过的带看，系统自动驳回所有待审核带看。";
                    $xiugai = "超过带看保护期无审核通过的带看，系统自动作废了".zym($value['adduid'],5)."提交的".$value['bianhao']."报备申请。";
                } else {
                    $bbbhq = M("xiaoqu")->where(array('id'=>$value['xiaoqu']))->getField('baobei');
                    $zhsx = $value['addtime']+($bbbhq*86400);
                    $xiugai = "超过报备保护期未带看，系统自动作废了".zym($value['adduid'],5)."提交的".$value['bianhao']."报备申请。";
                }
                if (time() > $zhsx) {
                    M("baobei")->where(array('id'=>$value['id']))->setField('jindu',4);
                    if ($isdk > 0) {
                        M("daikan")->where(array('zyid'=>$value['id'],'status'=>3))->setField('status',2);
                        $daikan = M("daikan")->where(array('zyid'=>$value['id'],'status'=>3))->select();
                        foreach ($daikan as $k => $val) {
                            $shid = M('shenhe')->where(array('type'=>2,'zyid'=>$val['id']))->getField('id');
                            $data_shenhe['status'] = 2;
                            $data_shenhe['remark'] = $remark;
                            $data_shenhe['shijian'] = time();
                            $data_shenhe['uid'] = $admin_id;
                            M('shenhe')->where(array('id'=>$shid))->save($data_shenhe);
                        }
                    }
                    $data_rizhi['zy_type'] = 4;
                    $data_rizhi['uid'] = $admin_id;
                    $data_rizhi['addtime'] = time();
                    $data_rizhi['cz_type'] = 18;
                    $data_rizhi['zy_id'] = $shenhe['id'];
                    $data_rizhi['zy_bianhao'] = $value['bianhao'];
                    $data_rizhi['neirong'] = $xiugai;
                    M('rizhi')->add($data_rizhi);
                }
            }
            echo 'ok';
        }
	}