<?php

	/*******************************************************************\
	|																	|
	|	房佳（新房报备ERP管理系统）										|
	|																	|
	|	© 2020-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	namespace Admin\Controller;
	use Think\Controller;
	class ShenheController extends CommonController {

		// 审核列表
		public function index(){
			$type = I('type',0,'int');
			$status = I('status',0,'int');
			switch ($type) {
				case 1:
					$node = 990;
					$shqx = 970;
					$shlx = "报备审核";
					break;
				case 2:
					$node = 991;
					$shqx = 972;
					$shlx = "带看审核";
					break;
				case 3:
					$node = 992;
					$shqx = 975;
					$shlx = "认筹审核";
					break;
				case 4:
					$node = 993;
					$shqx = 977;
					$shlx = "认购审核";
					break;
				case 5:
					$node = 994;
					$shqx = 979;
					$shlx = "签约审核";
					break;
				case 6:
					$node = 995;
					$shqx = 981;
					$shlx = "网签审核";
					break;
				case 7:
					$node = 996;
					$shqx = 983;
					$shlx = "结佣审核";
					break;
				default:
					$type = 0;
					$node = 989;
					$shqx = 997;
					$shlx = "所有审核";
					break;
			}
			if (I('is_ajax')) {
				$condition = "e.gongsiid = '".session('gongsiid')."'";
				$x = _rbac_lists_where($node,0);
				if ($x && $x != "all" && $x != "me") {
					$condition .= " and e.bumen in ({$x})";
				} elseif ($x == "me") {
					$condition .= " and e.id = '".session('uid')."'";
				} elseif ($x == false) {
					$condition .= " and e.id = 0";
				}
				$shijian = I('shijian');
				$bumen = I('bumen',0,'int');
				$sousuo = sql_check_param(I('sousuo'));
				if ($bumen) {
					$string = get_bm_sz($bumen,2);
					$condition .= " and e.bumen in ($string)";
				}
				if ($type) {
					$condition .= " and a.type = '$type'";
				}
				if ($status) {
					$condition .= " and a.status = '$status'";
				}
				if ($shijian) {
					$time_s = explode(' - ',$shijian);
					$time_s1 = strtotime($time_s[0]);
					$time_s2 = strtotime($time_s[1])+86400;
					$condition .= " and a.addtime >= '".$time_s1."' and a.addtime < '".$time_s2."'";
				}
				if ($sousuo) {
					$condition .= " and (a.zybh like '%$sousuo%' or e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%')";
				}
				$field = I('field'); //排序字段名
				$order = I('order'); //排序方式
				$limit = I('limit',30,'int'); //每页条数
				$limit = $limit > 150 ? 150 : $limit;
				if ($field && $order) {
					$shpx = "a.".$field." ".$order;
				} else {
					$shpx = "a.addtime desc";
				}
				$count = M('shenhe')->alias('a')->join('jjrxt_yonghu e on a.adduid=e.id')->where($condition)->count();
				$Page = I('p');
				$data = M('shenhe')->alias('a')->join('jjrxt_yonghu e on a.adduid=e.id')->field('a.*,e.ygmingcheng as sqren,e.dianhua as sqrdh,e.bumen as sqrbm')->where($condition)->order($shpx)->page($Page,$limit)->select();
				foreach ($data as $key => $value) {
					$whrid = M('baobei')->where(array('bianhao'=>$value['zybh']))->getField('whrid');
					$bianhao = explode("-",$value['zybh']);
					$data[$key]['bianhao'] = $value['zybh'] ? $value['zybh'] : "——";
					$data[$key]['zybh'] = $bianhao[1];
					switch ($value['type']) {
						case 1:
							$type = "报备";
							break;
						case 2:
							$type = "带看";
							break;
						case 3:
							$type = "认筹";
							break;
						case 4:
							$type = "认购";
							break;
						case 5:
							$type = "签约";
							break;
						case 6:
							$type = "网签";
							break;
						case 7:
							$type = "结佣";
							break;
						default:
							$type = "——";
							break;
					}
					$data[$key]['type'] = $type;
					$is_rbacsh = 0;
					switch ($value['status']) {
						case 1:
							$status = "已通过";
							break;
						case 2:
							$status = "已驳回";
							break;
						case 3:
							$status = "待审核";
							$is_rbacsh = _rbac_btn_show($shqx,0,$value['adduid']);
							break;
						default:
							$status = "——";
							break;
					}
					$data[$key]['status'] = $status;
					$shren = zym($value['uid'],5);
					$sqrbm = zym($value['sqrbm'],6);
					$data[$key]['shren'] = $shren ? $shren : "——";
					$data[$key]['sqrbm'] = $sqrbm ? $sqrbm : "——";
					$data[$key]['sqren'] = $value['sqren'] ? $value['sqren'] : "——";
					$data[$key]['sqrdh'] = $value['sqrdh'] ? $value['sqrdh'] : "——";
					$data[$key]['neirong'] = $value['neirong'] ? $value['neirong'] : "——";
					$data[$key]['remark'] = $value['remark'] ? $value['remark'] : "——";
					$data[$key]['shijian'] = $value['shijian'] ? date('Y-m-d H:i:s',$value['shijian']) : "——";
					$data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
					$is_rbacxq = _rbac_btn_show(969,0,$whrid);
					$data[$key]['rbacxq'] = $is_rbacxq ? 1 : 0;
					$data[$key]['rbacsh'] = $is_rbacsh ? 1 : 0;
				}
				$return_data = array(
					'code'=>0,
					'count'=>$count,
					'data'=>$data
				);
				$this->ajaxReturn($return_data);
			} else {
				$this->node = $node;
				$this->type = $type;
				$this->shlx = $shlx;
				$this->status = $status;
				$select_categorys = bumen_option($bumen,$node);
				$this->assign("select_categorys",$select_categorys);
				$this->display();
			}
		}

		// 审核
		public function shenhe(){
			$id = I('id',0,'int');
			$type = I('type',0,'int');
			switch ($type) {
				case 1:
					$node = 970;
					break;
				case 2:
					$node = 972;
					break;
				case 3:
					$node = 975;
					break;
				case 4:
					$node = 977;
					break;
				case 5:
					$node = 979;
					break;
				case 6:
					$node = 981;
					break;
				case 7:
					$node = 983;
					break;
				default:
					$type = 0;
					$node = 997;
					break;
			}
			$shenhe = M('shenhe')->where(array('id'=>$id))->field('type,zyid,zybh,adduid,status')->find();
			$is_rbac = _rbac_btn_show($node,0,$shenhe['adduid']);
			if (!$is_rbac) {
				$this->redirect('Index/error');
			}
			if ($shenhe['status'] == 1) {
				$this->error('已通过！');
			}
			if ($shenhe['status'] == 2) {
				$this->error('已驳回！');
			}
			switch ($shenhe['type']) {
				case 1:
					$jindu1 = 2;
					$jindu2 = 3;
					$type = "报备";
					$zyb = M('baobei');
					break;
				case 2:
					$jindu1 = 3;
					$jindu2 = 5;
					$type = "带看";
					$zyb = M('daikan');
					break;
				case 3:
					$jindu1 = 6;
					$jindu2 = 7;
					$type = "认筹";
					$zyb = M('renchou');
					break;
				case 4:
					$jindu1 = 8;
					$jindu2 = 9;
					$type = "认购";
					$zyb = M('rengou');
					break;
				case 5:
					$jindu1 = 10;
					$jindu2 = 11;
					$type = "签约";
					$zyb = M('qianyue');
					break;
				case 6:
					$jindu1 = 12;
					$jindu2 = 13;
					$type = "网签";
					$zyb = M('wangqian');
					break;
				case 7:
					$jindu1 = 14;
					$jindu2 = 15;
					$type = "结佣";
					$zyb = M('jieyong');
					break;
				default:
					$this->error('审核类型异常！');
					break;
			}
			if ($type > 0 && $shenhe['type'] != $type) {
				$this->error('异常错误！');
			}
			if (IS_POST) {
				$status = I('status',0,'int');
				$xiugai = session('ygmingcheng');
				switch ($status) {
					case 1:
						$tznr = "通过了";
						$xiugai .= "通过了";
						$jindu = $jindu2;
						$status = 1;
						break;
					case 2:
						$tznr = "驳回了";
						$xiugai .= "驳回了";
						$jindu = $jindu1;
						$status = 2;
						break;
					default:
						$this->error('请选择审核意见！');
						break;
				}
				$remark = preg_replace ( "/\s(?=\s)/","\\1",I('remark'));
				if (!preg_match("/^$|^[\s\S]{0,300}$/",$remark)) {
					$this->error('审核内容只能输入300个字符！');
				}
				$tznr .= "您提交的".$shenhe['zybh'].$type."申请，审核内容为：".$remark;
				$xiugai .= zym($shenhe['adduid'],5)."提交的".$shenhe['zybh'].$type."申请，审核内容为：".$remark;
				$data['status'] = $status;
				$data['remark'] = $remark;
				$data['shijian'] = time();
				$data['uid'] = session('uid');
				$isok = M('shenhe')->where(array('id'=>$id))->save($data);
				if ($isok) {
					if ($shenhe['type'] == 1) {
						$data_shyjd['jindu'] = $jindu;
						$data_shyjd['status'] = $status;
						$zyb->where(array('id'=>$shenhe['zyid']))->save($data_shyjd);
					} else {
						$zyb->where(array('id'=>$shenhe['zyid']))->setField('status',$status);
						M('baobei')->where(array('bianhao'=>$shenhe['zybh']))->setField('jindu',$jindu);
					}
					$data_rizhi['zy_type'] = 4;
					$data_rizhi['uid'] = session("uid");
					$data_rizhi['addtime'] = time();
					$data_rizhi['cz_type'] = 18;
					$data_rizhi['zy_id'] = $id;
					$data_rizhi['zy_bianhao'] = $shenhe['zybh'];
					$data_rizhi['neirong'] = $xiugai;
					M('rizhi')->add($data_rizhi);
					$data_xiaoxi['gongsiid'] = session('gongsiid');
					$data_xiaoxi['type'] = $shenhe['type'];
					$data_xiaoxi['zyid'] = $shenhe['zyid'];
					$data_xiaoxi['zybh'] = $shenhe['zybh'];
					$data_xiaoxi['uid'] = $shenhe['adduid'];
					$data_xiaoxi['remark'] = $tznr;
					$data_xiaoxi['adduid'] = session('uid');
					$data_xiaoxi['addtime'] = time();
					M('xiaoxi')->add($data_xiaoxi);
					$this->success('审核成功');
				} else {
					$this->error('审核失败！');
				}
			} else {
				$this->id = $id;
				$this->type = $type;
				$this->display();
			}
		}

	}