<?php

	/*******************************************************************\
	|																	|
	|	房佳（新房报备ERP管理系统）										|
	|																	|
	|	© 2020-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	/*---------------------------------权限函数开始---------------------------------*/

		function bumen_option($selected,$node_id){
			$x = $node_id ? _rbac_lists_where($node_id,0) : "null";
			$tree = new \Org\Util\Tree();
			$parentid = $selected;
			$result = M('bumen')->order(array("sort" => "ASC"))->select();
			foreach ($result as $key => $r) {
				$r['selected'] = $r['id'] == $parentid ? 'selected' : '';
				if ($x && $x != "all" && $x != "me" && $x != "null") {
					$b = explode(",",$x);
					if (in_array($r['id'],$b)) {
						$array[] = $r;
					}
				}elseif($x == 'me' || $x == false){
					$array = "";
				}elseif($x == 'all' || $x == 'null'){
					$array[] = $r;
				}
			}
			$a = 0;
			$l = 999;
			if ($x && $x != "all" && $x != "me" && $x != "null") {
				foreach ($array as $key => $value) {
					if ($value['level'] < $l) {
						$a = $value['parentid'];
						$l = $value['level'];
					}
				}
			}
			$str = "<option value='\$id' title='\$bmming' \$selected>\$spacer \$bmming</option>";
			$tree->init($array);
			$select_categorys = $tree->get_tree($a, $str);
			return $select_categorys;
		}

		function bumen_idsz($node_id){
			if ($node_id) {
				$bumen = _rbac_bumen_show($node_id,0);
				if (!$bumen) {
					$bumen = -1;
				}
				$arr_string = get_bm_sz($bumen,1);
				return $arr_string;
			}
		}

		/**
			* 二维数组排序
			* @param $arr
			* @param $keys
			* @param string $type
			* @return array
		*/

		function array_sort($arr, $keys, $type = 'desc') {
			$key_value = $new_array = array();
			foreach ($arr as $k => $v) {
				$key_value[$k] = $v[$keys];
			}
			if ($type == 'asc') {
				asort($key_value);
			} else {
				arsort($key_value);
			}
			reset($key_value);
			foreach ($key_value as $k => $v) {
				$new_array[$k] = $arr[$k];
			}
			return $new_array;
		}

		/*设置权限页面是否选中*/
		function _is_have_node($config,$role_id,$fanwei,$zhuangtai,$type){
			foreach ($config as $key => $value) {
				if ($value['zhuangtai'] == $zhuangtai && $value['fanwei'] == $fanwei) {
					if ($type == 1) {
						return "checked";
					}else{
						return "selected";
					}
				}
			}
			return "";
		}

		function _rbac_bumen_show($node_id,$zhuangtai){
			$fanwei = _rbac_range($node_id,$zhuangtai);
			if (!$fanwei) {
				return false;
			}elseif ($fanwei=='all') {
				return 'all';
			}elseif ($fanwei=='me') {
				return 'me';
			}
			$arr =_rbac_bumen_top_id($fanwei);
			if (!$arr) {
				return false;
			}
			return $arr["id"];
		}

		function _rbac_bumen_top_id($val){
			$b_id = M('yonghu')->where(array('id'=>session('uid')))->getField('bumen');
			$find = M('bumen')->where(array('id'=>$b_id))->find();
			$i = $find['level'];
			if ($find['level']<$val) {
				return false;
			}elseif ($find['level']==$val) {
				return $find;
			}elseif ($find['level']>$val) {
				$u = $find['level']-$val;
				for ($i=0; $i < $u; $i++) { 
					$find = M('bumen')->where(array('id'=>$find['parentid']))->find();
				}
				return $find;
			}
		}

		function _rbac_bumen_array($array,$id=0){
			$arr = array();
			foreach ($array as $v) {
				if ($v['parentid']==$id) {
					$arr[] = $v['id'];
					$a = _rbac_bumen_array($array,$v['id']);
					$arr = array_merge($arr, $a); 
				}
			}
			return $arr;
		}

		//获取相应节点和状态的 范围值
		function _rbac_range($node_id,$zhuangtai){
			if(session('username') == C('RBAC_SUPERADMIN')){
				return 'all';
			}
			$where['node_id'] = $node_id;
			$where['role_id'] = get_yh_role(session('uid'),1);
			$where['zhuangtai'] = $zhuangtai;
			$fanwei = M('access')->where($where)->find();
			if (!$fanwei) {
				return false;
			}
			if (!$fanwei['fanwei']){
				return 'all';
			}
			$me_level = _rbac_me_level();
			if ($fanwei['fanwei']==$me_level) {
				return 'me';
			}
			return $fanwei['fanwei'];
		}

		//获取范围生成逗号分隔的字符串
		function _rbac_in_bumen_string($node_id,$zhuangtai){
			$fanwei = _rbac_range($node_id,$zhuangtai);
			if (!$fanwei) {
				return false;
			}elseif ($fanwei=='all') {
				return 'all';
			}elseif ($fanwei=='me') {
				return 'me';
			}
			$arr =_rbac_bumen_top_id($fanwei);
			if (!$arr) {
				return false;
			}
			$string = get_bm_sz($arr['id'],2);
			return $string;
		}

		//根据节点状态和对应的人物 查看是否有权限
		function _rbac_btn_show($node_id,$zhuangtai,$uid){
			$string = _rbac_in_bumen_string($node_id,$zhuangtai);
			if (!$string) {
				return false;
			}elseif ($string=='all') {
				return true;
			}elseif ($string=='me') {
				if ($uid==session('uid')) {
					return true;
				} else {
					return false;
				}
			}
			$map['bumen'] = array('in',$string);
			$map['id'] = $uid;
			$find = M('yonghu')->where($map)->find();
			if ($find) {
				return true;
			}else{
				return false;
			}
		}

		function _rbac_node_show($node_id){
			if(session('username') == C('RBAC_SUPERADMIN')){
				return true;
			}
			$where['node_id'] = $node_id;
			$where['role_id'] = get_yh_role(session('uid'),1);
			$find = M('access')->where($where)->find();
			if ($find) {
				return true;
			}else{
				return false;
			}
		}

		function _rbac_me_level(){
			$count = count(get_options('bumen_options','bumen_array'));
			return $count+1;
		}

		function _rbac_lists_where($node_id,$zhuangtai){
			$string = _rbac_in_bumen_string($node_id,$zhuangtai);
			if (!$string) {
				return false;
			}elseif ($string=='all') {
				return 'all';
			}elseif ($string=='me') {
				return 'me';
			}
			return $string;
		}

	/*---------------------------------权限函数结束---------------------------------*/

	/**
		* 获取数据库中的配置列表
		* @return array 配置数组
	*/

	function lists(){
		$data = M('Configure')->where(array('status'=>1))->field('type,name,value')->select();
		$config = array();
		if($data && is_array($data)){
			foreach ($data as $value) {
				$config[$value['name']] =parse($value['type'], $value['value']);
			}
		}
		return $config;
	}

	/**
		* 根据配置类型解析配置
		* @param integer $type 配置类型
		* @param string $value 配置值
	*/

	function parse($type, $value){
		switch ($type) {
			//解析数组
			case 3:
				$array = preg_split('/[,;\r\n]+/', trim($value, ",;\r\n"));
				if(strpos($value,':')){
					$value = array();
					foreach ($array as $val) {
						list($k, $v) = explode(':', $val);
						$value[$k] = $v;
					}
				}else{
					$value = $array;
				}
				break;
		}
		return $value;
	}

	/**
	* 生成用户 token
	* @param $userId
	* @param $deviceType
	* @return string 用户 token
	*/
	function generate_user_token($type, $userId, $deviceType){
		$userTokenQuery = M("user_token")->where(array('type'=>$type,'user_id'=>$userId,'device_type'=> $deviceType));
		$findUserToken = $userTokenQuery->find();
		$currentTime = time();
		$expireTime = $currentTime + 24 * 3600;
		$token = md5(uniqid()).md5(uniqid());
		if (empty($findUserToken)) {
			M("user_token")->add([
				'token' => $token,
				'user_id' => $userId,
				'expire_time' => $expireTime,
				'create_time' => $currentTime,
				'device_type' => $deviceType,
				'type' => $type
			]);
		} else {
			M("user_token")
			->where(array('type'=>$type,'user_id'=>$userId,'device_type'=> $deviceType))
			->save([
				'token' => $token,
				'expire_time' => $expireTime,
				'create_time' => $currentTime
			]);
		}
		return $token;
	}

	//参数过滤防止SQL注入
	function filter_default(&$value){
		//判断magic_quotes_gpc是否为打开
		if (!get_magic_quotes_gpc()) {
			//进行magic_quotes_gpc没有打开的情况对提交数据的过滤
			$value = addslashes($value);
		}
		//回车转换
		$value = nl2br($value);
		//html标记转换
		$value = htmlspecialchars($value);
		$str = 'select|insert|and|or|update|delete|\'|\/\*|\*|\.\.\/|\.\/|union|into|load_file|outfile';
		if (eregi($str,$value)) {
			return '';
		}
		return $value;
	}

	//获取ip地址物理位置
	function findCityByIp($ip){
		$data = file_get_contents('http://ip.taobao.com/service/getIpInfo.php?ip='.$ip);
		$dizhi = json_decode($data,$assoc=true);
		$country = $dizhi['data']['country'];
		if (($country == "台湾") || ($country == "澳门") || ($country == "香港")) {
			$country = "中国";
		}
		return $country." ".$dizhi['data']['region']." ".$dizhi['data']['city']." ".$dizhi['data']['isp'];
	}

	//获取资源名
	function zym($zyid,$zylx){
		if ($zylx == 1) {
			$zym=M('xingzhengqu')->where(array('id'=>$zyid))->getField('xzqming');
		} elseif ($zylx == 2) {
			$zym=M('pianqu')->where(array('id'=>$zyid))->getField('pianqum');
		} elseif ($zylx == 3) {
			$zym=M('xiaoqu')->where(array('id'=>$zyid))->getField('xiaoqum');
		} elseif ($zylx == 5) {
			$zym=M('yonghu')->where(array('id'=>$zyid))->getField('ygmingcheng');
		} elseif ($zylx == 6) {
			$find = M('bumen')->where(array('id'=>$zyid))->find();
			$zym = $find['bmming'];
			$u = $find['level'];
			for ($i=0; $i < $u; $i++) { 
				$find = M('bumen')->where(array('id'=>$find['parentid']))->find();
				if ($find['bmming']) {
					$zym = $find['bmming']."—".$zym;
				}
			}
		} elseif ($zylx == 7) {
			$zym=M('bumen')->where(array('id'=>$zyid))->getField('bmming');
		} elseif ($zylx == 8) {
			$zym=M('role')->where(array('id'=>$zyid))->getField('remark');
		} elseif ($zylx == 9) {
			$options = get_options('bumen_options','bumen_array');
			$zym = $options[$zyid];
		} elseif ($zylx == 10) {
			$zym=M('zdxinxi')->where(array('id'=>$zyid))->getField('zdming');
		} elseif ($zylx == 11) {
			$zym=M('dyxinxi')->where(array('id'=>$zyid))->getField('dyming');
		} elseif ($zylx == 12) {
			$zym=M('lcxinxi')->where(array('id'=>$zyid))->getField('lcming');
		} elseif ($zylx == 13) {
			$zym=M('fjxinxi')->where(array('id'=>$zyid))->getField('fanghao');
		} elseif ($zylx == 14) {
			$zym=M('yonghu')->where(array('id'=>$zyid))->getField('dianhua');
		} elseif ($zylx == 15) {
			$zym=M('yonghu')->where(array('id'=>$zyid))->getField('ygbianhao');
		} elseif ($zylx == 16) {
			$yhtx = M('yonghu')->where(array('id'=>$zyid))->getField('touxiang');
			if ($yhtx == 1) {
				$zym = (isHTTPS() ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/Upload/Avatar/10000/".zym($zyid,14)."_200.jpg";
			} else {
				$zym = get_img_url("/Public/images/public_photo.jpg");
			}
		}
		return $zym;
	}

	function get_img_url($img_path){
		$img_url = (isHTTPS() ? 'https://' : 'http://') .$_SERVER['HTTP_HOST'].$img_path;
		return $img_url;
	}

	function get_html_url($html_path){
		$html_url = (isHTTPS() ? 'https://' : 'http://') .$_SERVER['HTTP_HOST'].$html_path;
		return $html_url;
	}

	//获取部门及下级部门的数组
	function get_bm_sz($bmid,$lx){
		$result = M('bumen')->order(array("sort" => "ASC"))->select();
		if ($bmid) {
			$arr_string = _rbac_bumen_array($result,$bmid);
			$arr_string[] = $bmid;
			if ($lx == 1) {
				$bm=$arr_string;
			} elseif ($lx == 2) {
				$bm = implode(',',$arr_string);
			}
			return $bm;
		}
	}

	//获取用户部门
	function yhbm($id,$lx){
		$bm=M('yonghu')->where(array('id'=>$id))->getField('bumen');
		if ($lx == 1) {
			$yhbm=$bm;
		} elseif ($lx == 2) {
			$yhbm=zym($bm,7);
		} elseif ($lx == 3) {
			$yhbm=zym($bm,6);
		}
		return $yhbm;
	}

	//获取用户角色（岗位）
	function get_yh_role($id,$lx){
		$role_id=M('role_user')->where(array('user_id'=>$id))->getField('role_id');
		if ($lx == 1) {
			return $role_id;
		} elseif ($lx == 2) {
			$remark=zym($role_id,8);
			return $remark;
		}
	}

	//获取用户可选角色（岗位）
	function yhkxrole($id,$lx){
		if (!$id) {
			$id=get_yh_role(session('uid'),1);
		}
		if ($lx == 1) {
			if (session('username') == C('RBAC_SUPERADMIN')) {
				$role=M('role')->where(array('gongsiid'=>session('gongsiid')))->order('rolefl asc,xsshunxu asc')->select();
			} else {
				$kxrole=M('role')->where(array('id'=>$id))->getField('kxrole');
				if (!$kxrole) {
					$kxrole="0";
				}
				$role=M('role')->where(array('gongsiid'=>session('gongsiid'),'id'=>array('in',$kxrole)))->order('rolefl asc,xsshunxu asc')->select();
			}
		} elseif ($lx == 2) {
			$kxrole=M('role')->where(array('id'=>$id))->getField('kxrole');
			$roleids=explode(",",$kxrole);
			foreach ($roleids as $key => $value) {
				$role[$value]=$value;
			}
		}
		return $role;
	}

	function isHTTPS(){
		if (defined('HTTPS') && HTTPS) return true;
		if (!isset($_SERVER)) return FALSE;
		if (!isset($_SERVER['HTTPS'])) return FALSE;
		if ($_SERVER['HTTPS'] === 1) {  //Apache
			return TRUE;
		} elseif ($_SERVER['HTTPS'] === 'on') { //IIS
			return TRUE;
		} elseif ($_SERVER['SERVER_PORT'] == 443) { //其他
			return TRUE;
		}
		return FALSE;
	}

	//获取小区封面图片
	function get_x_img($xqid){
		$img_urlf=M('xqphoto')->where(array('xqid'=>$xqid,'fengmian'=>1))->getField('image');
		if ($img_urlf) {
			$data['image'] = $img_urlf;
			$data['imgdt'] = (isHTTPS() ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/Upload/10000/xiaoqu/".$xqid."/".$img_urlf;
			$data['imgxt'] = (isHTTPS() ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/Upload/10000/xiaoqu/".$xqid."/t_".$img_urlf;
			return $data;
		} else {
			$img_url=M('xqphoto')->where(array('xqid'=>$xqid))->order('rand()')->limit(1)->getField('image');
			if ($img_url) {
				$data['image'] = $img_url;
				$data['imgdt'] = (isHTTPS() ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/Upload/10000/xiaoqu/".$xqid."/".$img_url;
				$data['imgxt'] = (isHTTPS() ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/Upload/10000/xiaoqu/".$xqid."/t_".$img_url;
				return $data;
			} else {
				return "";
			}
		}
	}

	//获取小区所有图片
	function get_x_imgs($xqid){
		$img_urls=M('xqphoto')->where(array('xqid'=>$xqid))->select();
		if ($img_urls) {
			foreach ($img_urls as $key => $value) {
				$data[$key]['image'] = $value['image'];
				$data[$key]['imgdt'] = (isHTTPS() ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/Upload/10000/xiaoqu/".$xqid."/".$value['image'];
				$data[$key]['imgxt'] = (isHTTPS() ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/Upload/10000/xiaoqu/".$xqid."/t_".$value['image'];
			}
			return $data;
		} else {
			return "";
		}
	}

	//获取配置信息
	function get_peizhi($pzm,$cxz,$lx){
		if ($lx == 1) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('xsshunxu asc')->select();
		} elseif ($lx == 2) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('xsshunxu asc')->field($cxz)->select();
		} elseif ($lx == 3) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'lxid'=>$cxz))->getField('lxming');
		} elseif ($lx == 4) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('lxid asc')->limit(1)->getField('lxming');
		} elseif ($lx == 5) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('lxid asc')->limit(1)->getField('lxid');
		} elseif ($lx == 6) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'lxming'=>$cxz,'zhuangtai'=>1))->getField('lxid');
		}
		return $peizhi;
	}

	//获取配置名或注释
	function get_pzmzs($pz,$lx){
		if ($lx == 1) {
			$pzmzs=M('peizhi')->where(array('id'=>$pz))->getField('pzming');
		} elseif ($lx == 2) {
			$pzmzs=M('peizhi')->where(array('id'=>$pz))->getField('zhushi');
		} elseif ($lx == 3) {
			$pzmzs=M('peizhi')->where(array('pzming'=>$pz))->getField('pzming');
		} elseif ($lx == 4) {
			$pzmzs=M('peizhi')->where(array('pzming'=>$pz))->getField('zhushi');
		} elseif ($lx == 5) {
			$pzmzs=M('peizhi')->where(array('zhushi'=>$pz))->getField('pzming');
		} elseif ($lx == 6) {
			$pzmzs=M('peizhi')->where(array('zhushi'=>$pz))->getField('zhushi');
		}
		return $pzmzs;
	}

	//获取全站配置
	function get_options($val,$zd){
		$value = M('options')->where(array('option_name'=>$val))->getField('option_value');
		$options=json_decode($value,true);
		if ($zd) {
			$options=$options[$zd];
		}
		return $options;
	}

	//获取拼音检索
	function get_pinyin($val){
		$py = new \Lib\Pinyin\Pinyin;
		$s = $py->qupinyin($val ,true);
		$q = $py->qupinyin($val);
		$pyjs = $s.' '.$q.' '.$val;
		return $pyjs;
	}

	//打印
	function p ($arr){
		echo '<pre>' . print_r($arr,true) . '</pre>';
	}

	//判断是否是移动端
	function ismobile() {
		// 如果有HTTP_X_WAP_PROFILE则一定是移动设备
		if (isset ($_SERVER['HTTP_X_WAP_PROFILE']))
			return true;
		//此条摘自TPM智能切换模板引擎，适合TPM开发
		if(isset ($_SERVER['HTTP_CLIENT']) &&'PhoneClient'==$_SERVER['HTTP_CLIENT'])
			return true;
		//如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
		if (isset ($_SERVER['HTTP_VIA']))
		//找不到为flase,否则为true
			return stristr($_SERVER['HTTP_VIA'], 'wap') ? true : false;
		//判断手机发送的客户端标志,兼容性有待提高
		if (isset ($_SERVER['HTTP_USER_AGENT'])) {
			$clientkeywords = array(
				'nokia','sony','ericsson','mot','samsung','htc','sgh','lg','sharp','sie-','philips','panasonic','alcatel','lenovo','iphone','ipod','blackberry','meizu','android','netfront','symbian','ucweb','windowsce','palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile'
			);
			//从HTTP_USER_AGENT中查找手机浏览器的关键字
			if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))) {
				return true;
			}
		}
		//协议法，因为有可能不准确，放到最后判断
		if (isset ($_SERVER['HTTP_ACCEPT'])) {
			// 如果只支持wml并且不支持html那一定是移动设备
			// 如果支持wml和html但是wml在html之前则是移动设备
			if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))) {
				return true;
			}
		}
		return false;
	}

	//获取配置变动信息
	function get_xiugai($xiugaiqian,$xiugaihou,$pzming) {
		$xgqian=get_peizhi($pzming,$xiugaiqian,3);
		$xghou=get_peizhi($pzming,$xiugaihou,3);
		$zhushi=get_pzmzs($pzming,4);
		return $zhushi."：[".$xgqian."]=>[".$xghou."]；";
	}

	function get_loupan_options($type,$arr,$junjia,$jianmian,$huxing) { //类型1给搜索数据，2反解；$arr反解的数组；反解后条件定义表的名称
		if ($type == 1) {
			$data['quyu'] = M('xingzhengqu')->field('id,xzqming')->select();
			$data['wuye'] = get_peizhi('xfwylx','0',1);
			$data['zhuangtai'] = get_peizhi('xlpzt','0',1);
			$data['junjia'] = array(
				array('lxming'=>'20000元/m²以下','lxid'=>'1'),
				array('lxming'=>'20000~30000元/m²','lxid'=>'2'),
				array('lxming'=>'30000~40000元/m²','lxid'=>'3'),
				array('lxming'=>'40000~50000元/m²','lxid'=>'4'),
				array('lxming'=>'50000~60000元/m²','lxid'=>'5'),
				array('lxming'=>'60000~80000元/m²','lxid'=>'6'),
				array('lxming'=>'80000元~100000元/m²','lxid'=>'7'),
				array('lxming'=>'100000元/m²以上','lxid'=>'8'),
				array('lxming'=>'200万/套以下','lxid'=>'9'),
				array('lxming'=>'200~300万/套','lxid'=>'10'),
				array('lxming'=>'300~400万/套','lxid'=>'11'),
				array('lxming'=>'400~500万/套','lxid'=>'12'),
				array('lxming'=>'500~600万/套','lxid'=>'13'),
				array('lxming'=>'600~800万/套','lxid'=>'14'),
				array('lxming'=>'800元~1000万/套','lxid'=>'15'),
				array('lxming'=>'1000万/套以上','lxid'=>'16')
			);
			$data['jianmian'] = array(
				array('lxming'=>'50m²以下','lxid'=>'1'),
				array('lxming'=>'50~70m²','lxid'=>'2'),
				array('lxming'=>'70~90m²','lxid'=>'3'),
				array('lxming'=>'90~110m²','lxid'=>'4'),
				array('lxming'=>'110~130m²','lxid'=>'5'),
				array('lxming'=>'130~150m²','lxid'=>'6'),
				array('lxming'=>'150~200m²','lxid'=>'7'),
				array('lxming'=>'200m²以上','lx id'=>'8')
			);
			$data['huxing']  = array(
				array('lxming'=>'一室','lxid'=>'1'),
				array('lxming'=>'二室','lxid'=>'2'),
				array('lxming'=>'三室','lxid'=>'3'),
				array('lxming'=>'四室','lxid'=>'4'),
				array('lxming'=>'五室','lxid'=>'5'),
			);
			return $data;
		} elseif ($type==2) {
			if($arr['junjia']){
				switch ($arr['junjia']) {
					case '1':
						$where["$junjia.junjia"]=array(array('ELT',20000));
						$where["$junjia.junjialx"]=1;
						break;
					case '2':
						$where["$junjia.junjia"]=array(array('GT',20000),array('ELT',30000));
						$where["$junjia.junjialx"]=1;
						break;
					case '3':
						$where["$junjia.junjia"]=array(array('GT',30000),array('ELT',40000));
						$where["$junjia.junjialx"]=1;
						break;
					case '4':
						$where["$junjia.junjia"]=array(array('GT',40000),array('ELT',50000));
						$where["$junjia.junjialx"]=1;
						break;
					case '5':
						$where["$junjia.junjia"]=array(array('GT',50000),array('ELT',60000));
						$where["$junjia.junjialx"]=1;
						break;
					case '6':
						$where["$junjia.junjia"]=array(array('GT',60000),array('ELT',80000));
						$where["$junjia.junjialx"]=1;
						break;
					case '7':
						$where["$junjia.junjia"]=array(array('GT',80000),array('ELT',100000));
						$where["$junjia.junjialx"]=1;
						break;
					case '8':
						$where["$junjia.junjia"]=array(array('GT',100000));
						$where["$junjia.junjialx"]=1;
						break;
					case '9':
						$where["$junjia.junjia"]=array(array('ELT',200));
						$where["$junjia.junjialx"]=2;
						break;
					case '10':
						$where["$junjia.junjia"]=array(array('GT',200),array('ELT',300));
						$where["$junjia.junjialx"]=2;
						break;
					case '11':
						$where["$junjia.junjia"]=array(array('GT',300),array('ELT',400));
						$where["$junjia.junjialx"]=2;
						break;
					case '12':
						$where["$junjia.junjia"]=array(array('GT',400),array('ELT',500));
						$where["$junjia.junjialx"]=2;
						break;
					case '13':
						$where["$junjia.junjia"]=array(array('GT',500),array('ELT',600));
						$where["$junjia.junjialx"]=2;
						break;
					case '14':
						$where["$junjia.junjia"]=array(array('GT',600),array('ELT',800));
						$where["$junjia.junjialx"]=2;
						break;
					case '15':
						$where["$junjia.junjia"]=array(array('GT',800),array('ELT',1000));
						$where["$junjia.junjialx"]=2;
						break;
					case '16':
						$where["$junjia.junjia"]=array(array('GT',1000));
						$where["$junjia.junjialx"]=2;
						break;
					default:
						$this->error('均价类型错误');
						break;
				}
			}
			if($arr['jianmian']) {	
				switch ($arr['jianmian']) {
					case '1':
						$where["$jianmian.jzmianji"]=array(array('ELT',50));
						break;
					case '2':
						$where["$jianmian.jzmianji"]=array(array('GT',50),array('ELT',70));
						break;
					case '3':
						$where["$jianmian.jzmianji"]=array(array('GT',70),array('ELT',90));
						break;
					case '4':
						$where["$jianmian.jzmianji"]=array(array('GT',90),array('ELT',110));
						break;
					case '5':
						$where["$jianmian.jzmianji"]=array(array('GT',110),array('ELT',130));
						break;
					case '6':
						$where["$jianmian.jzmianji"]=array(array('GT',130),array('ELT',150));
						break;
					case '7':
						$where["$jianmian.jzmianji"]=array(array('GT',150),array('ELT',200));
						break;
					case '8':
						$where["$jianmian.jzmianji"]=array(array('GT',200));
						break;
					default:
						$this->success('建面类型错误');
						break;
				}
			}
			if($arr['huxing']){
				$where["$huxing.shi"]=array('in',$arr['huxing']);
			}
			if($arr['quyu']){
				$where["$junjia.quyu"]=array('in',$arr['quyu']);
			}
			if($arr['wuye']){
				$where["$junjia.wuyelx"]=array('in',$arr['wuye']);
			}
			if($arr['zhuangtai']){
				$where["$junjia.loupanzt"]=array('in',$arr['zhuangtai']);
			}
			return $where;
		}
	}

	/**
		* curl get 请求
		* @param $url
		* @return mixed
	*/
	function cmf_curl_get($url) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_FAILONERROR, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_AUTOREFERER, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_TIMEOUT, 5);
		$SSL = substr($url, 0, 8) == "https://" ? true : false;
		if ($SSL) {
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 信任任何证书
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); // 检查证书中是否设置域名
		}
		$content = curl_exec($ch);
		curl_close($ch);
		return $content;
	}

	/**
	* 防止sql注入
	*/
	function sql_check_param($value) {
		return post_check(check_param($value));
	}

	/**
	* 防止sql注入自定义方法一
	* author: xiaochuan
	* @param: mixed $value 参数值
	*/
	function check_param($value=null) {
		$str = preg_match('select|insert|and|or|update|delete|\'|\/\*|\*|\.\.\/|\.\/|union|into|load_file|outfile',$value);
		if ($str) {
			return '';
		}
		return $value;
	}

	/**
	* 防止sql注入自定义方法二
	* author: xiaochuan
	* @param: mixed $value 参数值
	*/
	function post_check($value) {
		if(!get_magic_quotes_gpc()) {
			// 进行过滤
			$value = addslashes($value);
		}
		$value = str_replace("_", "\_", $value);
		$value = str_replace("%", "\%", $value);
		$value = nl2br($value);
		$value = htmlspecialchars($value);
		return $value;
	}