
#ifndef _CARDALL_H_
#define _CARDALL_H_


struct Scan_Para
{

	enum Scan_Mode
	{
		SCAN_GRAY_MODE      = 1,
		SCAN_BW_MODE		= 2,
		SCAN_TRUECOLOR_MODE = 4,
		SCAN_FILTER_MODE	= 64,
	};
	enum Scan_DPI
	{
		SCAN_200_DPI   = 200,
		SCAN_300_DPI   = 300,
		SCAN_400_DPI   = 400,
		SCAN_600_DPI   = 600,	
		SCAN_1200_DPI  = 1200,
	};


	int nLeft;   // seletecd scanning range in 1/100 inch for general scanner or 1/1000 for film scanner
	int nTop;
	int nRight;
	int nBottom;
	Scan_Mode sMode; 
	int nBrightness;         // from -100 to 100%
	int nContrast;          // from -100 to 100%
	Scan_DPI Resolution;
	int nGamma;     	    // from 1 to 99default 10
	int nHighlight;         // from 1 to 255,default 255
	int nQualityscan;       // 0 : speed scan 1:quality scan,default 1
};

typedef struct
{
	char name[40];   //
	char sex[10];     //Ա
	char people[20];  //壬ʶʱΪ
	char birthday[50]; //
	char address[200]; //ַʶʱǹ롢
	char signdate[50]; //ǩڣʶʱЧ 
	char validterm[50];  //ЧڣʶʱΪգ
	char number[40];   //֤룬ʶʱΪպ ʶ۰֤ͨҳʱΪ۰֤
	char other[100];    //ãʶʱ,ʶ۰֤ͨҳʱ֤ţ
	char szCodeOne[256];//ա̨֤۰֤ͨҳһл룬
	char szCodeTwo[256];//ա̨֤۰֤ͨҳڶл룬
}IDCARD_ALL;


extern "C" char* __stdcall GetVersionInfo();
extern "C" int __stdcall LoadIdcardLibrary();
extern "C" void __stdcall FreeIdcardLibrary();
extern "C" void __stdcall CalibrateScanner();
extern "C" int __stdcall GetButtonDownType();
extern "C" int __stdcall ScanImageEx( char* pchFilePath, short nButtonType );
extern "C" int __stdcall ScanImageEx_NoBack( char* pchFilePath, short nButtonType );
extern "C" int __stdcall ScanImageOther( char* pchFilePath, Scan_Para& sP );
extern "C" void __stdcall FeedBackScanner();
extern "C" int __stdcall RecogIdcardExALL( LPTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nHandPrint, int nContent, char* HeadImgFName, short nButtonType );
extern "C" int __stdcall RecogIdcardOnlyALL( LPCTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nHandPrint, int nContent, char* HeadImgFName );
extern "C" int __stdcall RecogIdcardRe( LPTSTR imgfile_name, IDCARD_ALL& card, bool bSaveResultFile, int nHandPrint, int nContent, char* HeadImgFName, short nType, bool bIsNeedRevers );
extern "C" int __stdcall RecogDPOnlyALL( LPCTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nContent, char* HeadImgFName );
extern "C" int __stdcall RecogDPALL( LPTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nContent, char* HeadImgFName );
extern "C" int __stdcall RecogPassPortOnlyALL( LPCTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nContent, char* HeadImgFName );
extern "C" int __stdcall RecogPassPortALL( LPTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nContent, char* HeadImgFName );
extern "C" int __stdcall RecogNewIdcardOnlyALL( LPCTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nContent, char* HeadImgFName );
extern "C" int __stdcall RecogNewIdcardALL( LPTSTR imgfile_name, IDCARD_ALL& card, bool bSaveResultFile, int nContent, char* HeadImgFName );
extern "C" int __stdcall RecogPassPortOnlyALL_Region( LPCTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nContent );
extern "C" int __stdcall RecogPassPortALL_Region( LPTSTR imgfile_name, IDCARD_ALL & card, bool bSaveResultFile, int nContent );
extern "C" int __stdcall RecogTBZOnlyALL(LPCTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" int __stdcall RecogTBZALL(LPTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" int __stdcall RecogFXZOnlyALL(LPCTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" int __stdcall RecogFXZALL(LPTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" int __stdcall RecogHXZOnlyALL(LPCTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" int __stdcall RecogHXZALL(LPTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" int __stdcall RecogMacaoHKFaceALL(LPTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" int __stdcall RecogMacaoHKFaceOnlyALL(LPTSTR imgfile_name,IDCARD_ALL & card,bool bSaveResultFile, int nContent,char* HeadImgFName);
extern "C" void __stdcall GetVidPid(DWORD* pVid, DWORD* pPid);

#endif