/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.launch;

/**
 * An Interface to provide a shutdown hook for JaxoDraw.
 *
 * @since 2.0
 */
public interface JaxoShutDown {

    /**
     * Shut down the program, this will be run after the GUI has disposed itself.
     *
     * @param status the shutdown status code.
     */
    void shutdown(int status);
}
