/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import java.awt.event.KeyEvent;

import java.beans.PropertyChangeEvent;

import javax.swing.JMenuItem;

import net.sf.jaxodraw.util.JaxoConstants;


/** The file menu items.
 * @since 2.0
 */
public class JaxoFileMenu extends JaxoMenu {
    private static final long serialVersionUID = 7526471155622776147L;

    /** Creates the file menu from the specified JaxoMainPanel. */
    public JaxoFileMenu() {
        super();

        this.add(newMenu());
        this.add(openMenuItem());
        this.add(openRecentMenu());

        addSeparator();

        this.add(closeMenuItem());
        this.add(saveMenuItem());
        this.add(saveAsMenuItem());
        this.add(renameMenuItem());

        addSeparator();

        this.add(importMenuItem());
        this.add(exportMenuItem());
        this.add(printMenuItem());

        addSeparator();

        this.add(quitMenuItem());

        JaxoMenuUtils.setLanguageKey(this, "File");
        updateLanguage();
    }

    /**
     * Applies a property change event.
     *
     * @param e the change event.
     */
    public void propertyChange(final PropertyChangeEvent e) {
        firePropertyChange(e.getPropertyName(), e.getOldValue(),
            e.getNewValue());
    }

      //
     // private methods
    //

    private JMenuItem quitMenuItem() {
        final JMenuItem quitMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(quitMI, KeyEvent.VK_Q, DEFAULT_MASK);
        JaxoMenuUtils.setActionCommand(quitMI, JaxoConstants.QUIT);
        JaxoMenuUtils.setLanguageKey(quitMI, "Quit");
        return quitMI;
    }

    private JMenuItem printMenuItem() {
        final JMenuItem printMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(printMI, KeyEvent.VK_P, DEFAULT_MASK);
        JaxoMenuUtils.setActionCommand(printMI, JaxoConstants.PRINT);
        JaxoMenuUtils.setLanguageKey(printMI, "Print");
        return printMI;
    }

    private JMenuItem exportMenuItem() {
        final JMenuItem exportMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(exportMI, KeyEvent.VK_R, DEFAULT_MASK + SHIFT_MASK);
        JaxoMenuUtils.setActionCommand(exportMI, JaxoConstants.EXPORT);
        JaxoMenuUtils.setLanguageKey(exportMI, "Export");
        return exportMI;
    }

    private JMenuItem importMenuItem() {
        final JMenuItem importMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(importMI, KeyEvent.VK_R, DEFAULT_MASK);
        JaxoMenuUtils.setActionCommand(importMI, JaxoConstants.IMPORT);
        JaxoMenuUtils.setLanguageKey(importMI, "Import");
        return importMI;
    }

    private JMenuItem renameMenuItem() {
        final JMenuItem renameMI = new JMenuItem();
        JaxoMenuUtils.setActionCommand(renameMI, JaxoConstants.RENAME_TAB);
        JaxoMenuUtils.setLanguageKey(renameMI, "Rename_tab");
        return renameMI;
    }

    private JMenuItem saveAsMenuItem() {
        final JMenuItem saveasMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(saveasMI, KeyEvent.VK_S, DEFAULT_MASK + SHIFT_MASK);
        JaxoMenuUtils.setActionCommand(saveasMI, JaxoConstants.SAVE_AS);
        JaxoMenuUtils.setLanguageKey(saveasMI, "Save_as");
        return saveasMI;
    }

    private JMenuItem saveMenuItem() {
        final JMenuItem saveMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(saveMI, KeyEvent.VK_S, DEFAULT_MASK);
        JaxoMenuUtils.setActionCommand(saveMI, JaxoConstants.SAVE);
        JaxoMenuUtils.setLanguageKey(saveMI, "Save");
        return saveMI;
    }

    private JMenuItem closeMenuItem() {
        final JMenuItem closeMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(closeMI, KeyEvent.VK_X, DEFAULT_MASK + SHIFT_MASK);
        JaxoMenuUtils.setActionCommand(closeMI, JaxoConstants.CLOSE);
        JaxoMenuUtils.setLanguageKey(closeMI, "Close");
        return closeMI;
    }

    private JMenuItem openMenuItem() {
        final JMenuItem openMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(openMI, KeyEvent.VK_O, DEFAULT_MASK);
        JaxoMenuUtils.setActionCommand(openMI, JaxoConstants.OPEN);
        JaxoMenuUtils.setLanguageKey(openMI, "Open");
        return openMI;
    }

    private JaxoMenu openRecentMenu() {
        final JaxoMenu openRecentM = new OpenRecentMenu();
        this.addPropertyChangeListener(openRecentM);
        return openRecentM;
    }

    private JaxoMenu newMenu() {
        final JaxoMenu newMenu = new NewMenu();
        this.addPropertyChangeListener(newMenu);
        return newMenu;
    }
}
