/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import java.awt.event.ActionListener;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JMenuBar;

import net.sf.jaxodraw.util.JaxoLocalized;


/** The menu bar that holds the file, edit, options and help menus.
 * @since 2.0
 */
public class JaxoMenuBar extends JMenuBar implements PropertyChangeListener,
    JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;

    /**
     * Constructs the menu bar, adding file, edit, options and help menus.
     *
     * @param l an ActionListener to receive events from this MenuBar.
     */
    public JaxoMenuBar(final ActionListener l) {
        super();
        this.addPropertyChangeListener((JaxoMenu) this.add(new JaxoFileMenu()));
        this.addPropertyChangeListener((JaxoMenu) this.add(new JaxoEditMenu()));
        this.addPropertyChangeListener((JaxoMenu) this.add(new JaxoOptionsMenu()));
        this.addPropertyChangeListener((JaxoMenu) this.add(new JaxoHelpMenu()));
        addActionListener(l);
    }

    /**
     * Dispatches the event to the sub-panels.
     *
     * @param e the change event.
     */
    public void propertyChange(final PropertyChangeEvent e) {
        // dispatch to sub-panels
        firePropertyChange(e.getPropertyName(), e.getOldValue(),
            e.getNewValue());
    }

    /**
     * Adds the given ActionListener to all menus in this menu bar.
     *
     * @param l The ActionListener to add.
     */
    private void addActionListener(final ActionListener l) {
        for (int i = 0; i < getMenuCount(); i++) {
            getMenu(i).addActionListener(l);
        }
    }

    /** {@inheritDoc} */
    public final void updateLanguage() {
        for (int i = 0; i < getMenuCount(); i++) {
            ((JaxoMenu) getMenu(i)).updateLanguage();
        }
    }

}
