/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import java.awt.event.KeyEvent;

import java.beans.PropertyChangeEvent;

import javax.swing.JMenuItem;

import net.sf.jaxodraw.util.JaxoConstants;

/**
 * A JaxoMenu for newGraph and newTab MenuItems.
 */
public class NewMenu extends JaxoMenu {
    private static final long serialVersionUID = 7526471155622776147L;

    /** Creates a new instance of NewMenu. */
    public NewMenu() {
        super();
        this.add(newGraphMenuItem());
        this.add(newTabMenuItem());

        JaxoMenuUtils.setLanguageKey(this, "New");
    }

    /**
     * Applies a property change event.
     *
     * @param e the change event.
     */
    public void propertyChange(final PropertyChangeEvent e) {
        // nothing to do
    }

      //
     // private methods
    //

    private JMenuItem newTabMenuItem() {
        final JMenuItem newTabMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(newTabMI, KeyEvent.VK_T, DEFAULT_MASK);
        JaxoMenuUtils.setActionCommand(newTabMI, JaxoConstants.NEWT);
        JaxoMenuUtils.setLanguageKey(newTabMI, "New_tab");
        return newTabMI;
    }

    private JMenuItem newGraphMenuItem() {
        final JMenuItem newGraphMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(newGraphMI, KeyEvent.VK_N, DEFAULT_MASK);
        JaxoMenuUtils.setActionCommand(newGraphMI, JaxoConstants.NEWG);
        JaxoMenuUtils.setLanguageKey(newGraphMI, "New_graph");
        return newGraphMI;
    }
}
