/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import java.awt.event.KeyEvent;

import java.beans.PropertyChangeEvent;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;

import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoUtils;

/**
 * A JaxoMenu for vertex type MenuItems.
 */
public class VertexMenu extends JaxoMenu {
    private static final long serialVersionUID = 7526471155622776147L;
    private final JRadioButtonMenuItem type1BT;
    private final JRadioButtonMenuItem type2BT;
    private final JRadioButtonMenuItem type3BT;
    private final JRadioButtonMenuItem type4BT;
    private final JRadioButtonMenuItem type5BT;
    private final JRadioButtonMenuItem type6BT;

    /**
     * Creates a new instance of VertexMenu.
     *
     * @param initValue the initially selected vertex type.
     */
    public VertexMenu(final int initValue) {
        super();
        final ButtonGroup vertexGroup = new ButtonGroup();

        type1BT =
            new JRadioButtonMenuItem(JaxoUtils.newImageIcon("vertexsT1.png"),
                true);
        type2BT =
            new JRadioButtonMenuItem(JaxoUtils.newImageIcon("vertexsT2.png"));
        type3BT =
            new JRadioButtonMenuItem(JaxoUtils.newImageIcon("vertexsT3.png"));
        type4BT =
            new JRadioButtonMenuItem(JaxoUtils.newImageIcon("vertexsT4.png"));
        type5BT =
            new JRadioButtonMenuItem(JaxoUtils.newImageIcon("vertexsT5.png"));
        type6BT =
            new JRadioButtonMenuItem(JaxoUtils.newImageIcon("vertexsT6.png"));

        JaxoMenuUtils.setAccelerator(type1BT, KeyEvent.VK_D, SHIFT_MASK);
        JaxoMenuUtils.setAccelerator(type2BT, KeyEvent.VK_C, SHIFT_MASK);
        JaxoMenuUtils.setAccelerator(type3BT, KeyEvent.VK_S, SHIFT_MASK);
        JaxoMenuUtils.setAccelerator(type4BT, KeyEvent.VK_X, SHIFT_MASK);
        JaxoMenuUtils.setAccelerator(type5BT, KeyEvent.VK_T, SHIFT_MASK);
        JaxoMenuUtils.setAccelerator(type6BT, KeyEvent.VK_I, SHIFT_MASK);

        JaxoMenuUtils.setActionCommand(type1BT, JaxoConstants.VERTEXT1);
        JaxoMenuUtils.setActionCommand(type2BT, JaxoConstants.VERTEXT2);
        JaxoMenuUtils.setActionCommand(type3BT, JaxoConstants.VERTEXT3);
        JaxoMenuUtils.setActionCommand(type4BT, JaxoConstants.VERTEXT4);
        JaxoMenuUtils.setActionCommand(type5BT, JaxoConstants.VERTEXT5);
        JaxoMenuUtils.setActionCommand(type6BT, JaxoConstants.VERTEXT6);

        JaxoMenuUtils.setLanguageKey(type1BT, "JaxoVertex.type.dot");
        JaxoMenuUtils.setLanguageKey(type2BT, "JaxoVertex.type.circleCross");
        JaxoMenuUtils.setLanguageKey(type3BT, "JaxoVertex.type.square");
        JaxoMenuUtils.setLanguageKey(type4BT, "JaxoVertex.type.cross");
        JaxoMenuUtils.setLanguageKey(type5BT, "JaxoVertex.type.triangle");
        JaxoMenuUtils.setLanguageKey(type6BT, "JaxoVertex.type.diamond");

        vertexGroup.add(type1BT);
        vertexGroup.add(type2BT);
        vertexGroup.add(type3BT);
        vertexGroup.add(type4BT);
        vertexGroup.add(type5BT);
        vertexGroup.add(type6BT);

        this.add(type1BT);
        this.add(type2BT);
        this.add(type3BT);
        this.add(type4BT);
        this.add(type5BT);
        this.add(type6BT);

        JaxoMenuUtils.setLanguageKey(this, "Vertex_types");
        updateVertexType(initValue);
    }

    /**
     * Applies a property change event.
     *
     * @param e the change event.
     */
    public void propertyChange(final PropertyChangeEvent e) {
        final String name = e.getPropertyName();
        if ("Jaxo.vertexType".equals(name)) {
            updateVertexType(((Integer) e.getNewValue()).intValue());
        }
    }

    /**
     * Notification on change of vertex type.
     * Sets the radio button to the current vertex type in the pop-up menu.
     *
     * @param value Specifies the current vertex type.
     */
    private void updateVertexType(final int value) {
        if (value == JaxoConstants.VERTEXT1) {
            type1BT.setSelected(true);
        } else if (value == JaxoConstants.VERTEXT2) {
            type2BT.setSelected(true);
        } else if (value == JaxoConstants.VERTEXT3) {
            type3BT.setSelected(true);
        } else if (value == JaxoConstants.VERTEXT4) {
            type4BT.setSelected(true);
        } else if (value == JaxoConstants.VERTEXT5) {
            type5BT.setSelected(true);
        } else if (value == JaxoConstants.VERTEXT6) {
            type6BT.setSelected(true);
        }
    }
}
