/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.gui.panel;

import java.awt.event.ActionListener;

/**
 * Communicate events between panel components.
 *
 * @since 2.1
 */
public interface JaxoCommunicator extends ActionListener {

    /**
     * Distributes a property change to all sub-panels.
     *
     * @param name the name of the property. Not null.
     * @param oldValue the old value of the property.
     * @param newValue the new value of the property.
     */
    void distributePropertyChange(String name, Object oldValue, Object newValue);

    /**
     * Distributes a property change to all sub-panels.
     *
     * @param name the name of the property. Not null.
     * @param oldValue the old value of the property.
     * @param newValue the new value of the property.
     */
    void distributePropertyChange(String name, boolean oldValue, boolean newValue);

    /**
     * Distributes a property change to all sub-panels.
     *
     * @param name the name of the property. Not null.
     * @param oldValue the old value of the property.
     * @param newValue the new value of the property.
     */
    void distributePropertyChange(String name, int oldValue, int newValue);

    /**
     * Finalize a general shutdown on all sub-components.
     *
     * @param exitStatus The exit status code.
     */
    void shutdown(int exitStatus);
}
