/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;


/** A panel to change the dash of an object.
 * @since 2.0
 */
public class JaxoDashEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner spdsin;

    /** Constructor: returns a dash edit panel with default dash of 1.0. */
    public JaxoDashEditPanel() {
        this(1.f);
    }

    /** Constructor: returns a dash edit panel with the given dash.
     * @param oldDash The dash of the object to edited by this panel.
     */
    public JaxoDashEditPanel(final float oldDash) {
        super();
        this.setLayout(new GridLayout(1, 2, 10, 0));

        final JLabel dsin = createI18NLabel("JaxoDashEditPanel.size");

        final SpinnerNumberModel modeldsin =
            new SpinnerNumberModel(oldDash, 0.2, 50.0, 0.2);
        this.spdsin = new JaxoFixedJSpinner(modeldsin);
        spdsin.setName("dash");

        final TitledBorder dimSTitle = createI18NBorder("JaxoDashEditPanel.title");
        this.setBorder(dimSTitle);
        this.add(dsin);
        this.add(spdsin);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            spdsin.addChangeListener(listener);
        }
    }
}
