/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JSpinner;


/** A panel to change the scale of a group object.
 * @since 2.0
 */
public class JaxoScaleEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner scaleSpinner;

    /** Constructor: returns a scale edit panel with default scale of 1.0. */
    public JaxoScaleEditPanel() {
        this(1.f);
    }

    /** Constructor: returns a stroke edit panel with the given scale.
     * @param oldScale The scale of the object to edited by this panel.
     */
    public JaxoScaleEditPanel(final float oldScale) {
        super();
        this.setLayout(getPanelLayout());
        this.scaleSpinner = getSpinner(oldScale, 0.f, 10.f, 0.1f, "scale");
        this.setBorder(createI18NBorder("JaxoScaleEditPanel.title"));
        this.add(createI18NLabel("JaxoScaleEditPanel.scale"));
        this.add(scaleSpinner);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            scaleSpinner.addChangeListener(listener);
        }
    }
}
