/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JSpinner;


/** A panel to change the stroke of an object.
 * @since 2.0
 */
public class JaxoStrokeEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner spstin;

    /** Constructor: returns a stroke edit panel with default stroke of 1.0. */
    public JaxoStrokeEditPanel() {
        this(1.f);
    }

    /** Constructor: returns a stroke edit panel with the given stroke.
     * @param oldStroke The stroke of the object to edited by this panel.
     */
    public JaxoStrokeEditPanel(final float oldStroke) {
        super();
        this.setLayout(getPanelLayout());
        this.spstin = getSpinner(oldStroke, 0.f, 100.f, 0.1f, "stroke");
        this.setBorder(createI18NBorder("JaxoStrokeEditPanel.title"));
        this.add(createI18NLabel("JaxoStrokeEditPanel.width"));
        this.add(spstin);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            spstin.addChangeListener(listener);
        }
    }
}
