/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JTextArea;
import javax.swing.JScrollPane;


/** A panel to change the text of a text object.
 * @since 2.0
 */
public class JaxoTextEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;

    private final transient JTextArea textArea = new JTextArea(4, 25);

    /** Constructor: returns a Text edit panel with
     * an empty string as initial value.
     */
    public JaxoTextEditPanel() {
        this("");
    }

    /** Constructor: returns a Text edit panel with
     * the given string as initial value.
     * @param string The initial value of the string.
     */
    public JaxoTextEditPanel(final String string) {
        super();
        textArea.setText(string);
        textArea.setName("text");
        textArea.setWrapStyleWord(true);

        this.setLayout(getPanelLayout());
        this.setBorder(createI18NBorder("JaxoTextEditPanel.title"));
        this.add(new JScrollPane(textArea));
    }

    /** Adds the given listener as a DocumentListener to the text field
     * of this panel. If listener is null, does nothing.
     * @param listener The listener to add to this panel.
     */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            textArea.getDocument().addDocumentListener(listener);
        }
    }
}
