/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;


/** A panel to change the wiggle of an object.
 * @since 2.0
 */
public class JaxoWiggleEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;

    private transient JSpinner spampin;
    private transient JSpinner spwigin;

    /** Constructor: returns a wiggle edit panel with default wiggle and amplitude of 10. */
    public JaxoWiggleEditPanel() {
        this(10, 10);
    }

    /** Constructor: returns a wiggle edit panel with the given wiggle.
     * @param oldAmp The amplitude of the object to be edited by this panel.
     * @param oldWiggle The wiggle of the object to be edited by this panel.
     */
    public JaxoWiggleEditPanel(final int oldAmp, final int oldWiggle) {
        super();
        this.setLayout(new GridLayout(2, 2, 10, 0));

        final JLabel ampin = createI18NLabel("JaxoWiggleEditPanel.amplitude");

        final SpinnerNumberModel modelampin =
            new SpinnerNumberModel(oldAmp, -500, 500, 1);
        this.spampin = new JaxoFixedJSpinner(modelampin);
        spampin.setName("amp");

        final JLabel wigin = createI18NLabel("JaxoWiggleEditPanel.wiggles");

        final SpinnerNumberModel modelwigin =
            new SpinnerNumberModel(oldWiggle, 1, 1000, 1);
        this.spwigin = new JaxoFixedJSpinner(modelwigin);
        spwigin.setName("wiggle");

        final TitledBorder awSTitle = createI18NBorder("JaxoWiggleEditPanel.title");
        this.setBorder(awSTitle);
        this.add(ampin);
        this.add(spampin);
        this.add(wigin);
        this.add(spwigin);
    }

    /** Constructor: returns a wiggle edit panel with the given wiggle.
     * @param oldAmp The amplitude of the object to be edited by this panel.
     */
    public JaxoWiggleEditPanel(final int oldAmp) {
        super();
        this.setLayout(new GridLayout(1, 0));

        final JLabel ampin = createI18NLabel("JaxoWiggleEditPanel.amplitude");

        final SpinnerNumberModel modelampin =
            new SpinnerNumberModel(oldAmp, -500, 500, 1);
        this.spampin = new JaxoFixedJSpinner(modelampin);
        spampin.setName("amp");

        final TitledBorder awSTitle = createI18NBorder("JaxoWiggleEditPanel.title");
        this.setBorder(awSTitle);
        this.add(ampin);
        this.add(spampin);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            spampin.addChangeListener(listener);
            if (spwigin != null) {
                spwigin.addChangeListener(listener);
            }
        }
    }
}
