/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.logging;

import java.util.logging.Level;


/**
 * Interface that defines a logger for JaxoDraw.
 *
 * @since 2.0
 */
public interface JaxoLogger {

    /**
     * Logs an exception and/or a message at a given level.
     * Either the message or the exception have to be non-null.
     *
     * @param level the log level.
     * @param message a message to log.
     * @param e an exception to log.
     */
    void log(Level level, String message, Throwable e);

    /**
     * Check if a message of the given level would actually
     * be logged by this logger.
     *
     * @param level a message logging level.
     * @return true if the given message level is currently being logged.
     */
    boolean isLoggable(Level level);

    /**
     * Sets the logging level. Currently only Level.FINE, Level.INFO
     * and Level.WARNING are used by JaxoDraw.
     *
     * @param level the log level to set.
     */
    void setLevel(Level level);

    /**
     * Returns the current log level of this Logger.
     *
     * @return the current log level.
     */
    Level getLevel();
}
