/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

/**
 * Formats log records in standard JaxoDraw format.
 */
public class LogFormatter extends SimpleFormatter {
    /**
     * Formats the given LogRecord to standard JaxoDraw format.
     *
     * @param rec the LogRecord to format.
     * @return the formatted LogRecord.
     */
    @Override
    public String format(final LogRecord rec) {
        String prefix = "";
        final String nl = System.getProperty("line.separator");
        final int level = rec.getLevel().intValue();
        if (level == Level.INFO.intValue()) {
            prefix = "[INFO] ";
        } else if (level == Level.FINE.intValue()) {
            prefix = "[DEBUG] ";
        } else if (level == Level.WARNING.intValue()) {
            prefix = "[WARNING] ";
        }

        final StringBuffer buf = new StringBuffer(1000);
        final String[] lines = formatMessage(rec).split(nl, -1);
        for (int i = 0; i < lines.length; i++) {
            buf.append(prefix);
            buf.append(lines[i]);
            buf.append(nl);
        }
        return buf.toString();
    }
}
