/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object;


/**
 * Interface for objects that can be rotated.
 */
public interface JaxoRotationObject {
    /**
     * Returns the rotationAngle property of this rotation object.
     *
     * @return The rotationAngle property of this rotation object.
     */
    int getRotationAngle();

    /**
     * Sets the rotationAngle property of this rotation object.
     *
     * @param angle The rotationAngle (in degrees) of this rotation object.
     */
    void setRotationAngle(int angle);
}
