/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.line;

import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;


/** A ghost line.
 * @since 2.0
 */
public class JaxoGLine extends JaxoDashLine {
    private static final long serialVersionUID = 314159L;

    /** {@inheritDoc} */
    @Override
    public boolean isCopy(final JaxoObject comp) {
        boolean isCopy = false;

        if (comp instanceof JaxoGLine) {
            isCopy = super.isCopy(comp);
        }

        return isCopy;
    }

    /** {@inheritDoc} */
    protected float[] strokeDashes() {
        return new float[]{getDash(), getDash() * 4};
    }

    /** {@inheritDoc} */
    @Override
    public void setPreferences() {
        super.setPreferences();
        setDash(GHOST_DASH);
    }
    /** {@inheritDoc} */
    public void prepareEditPanel(final JaxoObjectEditPanel editPanel) {
        editPanel.add2PointsPanel(getPoints(), 0, 0);
        editPanel.addArrowPanel(isPaintArrow(), isFlip(), getArrowPosition(), 1, 0);
        editPanel.addArrowOptionsEditPanel(getArrow(), 2, 0);
        editPanel.addDoubleLinePanel(isDoubleLine(), getDLSeparation(), 0, 1);
        editPanel.addStrokePanel(getStrokeWidth(), 1, 1);
        editPanel.addDashPanel(getDash(), 2, 1);
        editPanel.addColorPanel(getColor(), JaxoObjectEditPanel.TYPE_LINE_COLOR, 3, 1);

        editPanel.setTitleAndIcon("Ghost_line_parameters", "gline.png");
    }
}
