/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.loop;

import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;


/** A ghost loop.
 * @since 2.0
 */
public class JaxoGLoop extends JaxoDashLoop {
    private static final long serialVersionUID = 314159L;

    /** {@inheritDoc} */
    @Override
    public final boolean isCopy(final JaxoObject comp) {
        boolean isCopy = false;

        if (comp instanceof JaxoGLoop) {
            isCopy = super.isCopy(comp);
        }

        return isCopy;
    }

    /** {@inheritDoc} */
    protected float[] strokeDashes() {
        return new float[]{getDash(), 4 * getDash()};
    }

    /** {@inheritDoc} */
    protected float[] innerStrokeDashes(final double radius) {
        float cf1 = 1.f;
        final float dlsep = getDLSeparation() / 2.f;

        if (radius > dlsep) {
            cf1 = (float) ((radius - dlsep) / radius);
        }

        return new float[]{cf1 * getDash(), 4 * cf1 * getDash()};
    }

    /** {@inheritDoc} */
    protected float[] outerStrokeDashes(final double radius) {
        float cf1 = 1.f;

        if (radius > 0) {
            cf1 = (float) ((radius + getDLSeparation() / 2.f) / radius);
        }

        return new float[]{cf1 * getDash(), 4 * cf1 * getDash()};
    }

    /** {@inheritDoc} */
    @Override
    public void setPreferences() {
        setDash(GHOST_DASH); // needs to be called before super, why?
        super.setPreferences();
    }

    /** {@inheritDoc} */
    public void prepareEditPanel(final JaxoObjectEditPanel editPanel) {
        final int r = (int) Math.round(getRadius());

        editPanel.addXYRPanel(getX(), getY(), r, 0, 0);
        //editPanel.addArrowPanel(isPaintArrow(), isFlip(), false, false, 1, 0);
        editPanel.addArrowPanel(isPaintArrow(), isFlip(), getArrowPosition(), 1, 0);
        editPanel.addArrowOptionsEditPanel(getArrow(), 2, 0);
        editPanel.addStrokePanel(getStrokeWidth(), 0, 1);
        editPanel.addDashPanel(getDash(), 1, 1);
        editPanel.addDoubleLinePanel(isDoubleLine(), getDLSeparation(), 2, 1);
        editPanel.addColorPanel(getColor(), JaxoObjectEditPanel.TYPE_LINE_COLOR, 3, 1);

        editPanel.setTitleAndIcon("Ghost_loop_parameters", "gloop.png");
    }

}
