/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.plugin;

import net.sf.jaxodraw.util.JaxoLocalized;

/**
 * A plugin for JaxoDraw.
 *
 * @since 2.0
 */
public interface JaxoPlugin extends JaxoLocalized {
    /**
     * This must return the class name of the plugin (MyPlugin.class.getName()).
     * It is used to uniquely identify the plugin.
     *
     * @return the class name of the plugins' main class.
     */
    String pluginId();

    /**
     * Return a short name for this plugin.  This is used to construct names
     * of output files, eg to get a "jaxodraw-pdf-plugin.properties" file,
     * the short name should just be "pdf".
     *
     * @return The short name of this plugin.
     */
    String getShortName();

    /**
     * Return the name of this plugin.
     * This is the name that will be presented in the JaxoDraw user interface.
     * For standard plugins the name should be of the form
     * "jaxodraw-" + getShortName() + "-plugin", but it can be anything else.
     *
     * @return the name of this plugin.
     */
    String pluginName();

    /**
     * Return a short description (preferably internationalized)
     * of what this plugin does.
     *
     * @return a description.
     */
    String description();

    /**
     * Return the version number of this plugin.
     * This should be a String in the format used by JaxoDraw as specified in
     * {@link net.sf.jaxodraw.util.JaxoInfo#compareVersions(String,String)
     * JaxoInfo.compareVersions}.
     *
     * @return the version.
     */
    String version();

    /**
     * Checks some eventual runtime requirements for the plugin.
     *
     * @return True if this plugin can be used at runtime.
     */
    boolean makeAvailableAtRuntime();

    /**
     * Each plugin should be able to load a set of properties
     * from some default location. The default JaxoDraw property files
     * are stored in the plugins cache directory and named like
     * "jaxodraw-{@link #getShortName()}-plugin.properties".
     */
    void loadProperties();
}
