/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.plugin;


/**
 * An exception occuring during the execution of a plugin.
 *
 * @since 2.0
 */
public class JaxoPluginExecutionException extends Exception {
    private static final long serialVersionUID = 7526471155622776147L;

    private final Object src;

    /**
     * Construct a new JaxoPluginExecutionException exception.
     *
     * @param source the source of the Exception, may be null.
     */
    public JaxoPluginExecutionException(final Object source) {
        super();
        this.src = source;
    }

    /**
     * Construct a new JaxoPluginExecutionException exception with a message.
     *
     * @param message a message. This could be displayed in error dialogs,
     * so it should be an internationalized string.
     * @param source the source of the Exception, may be null.
     */
    public JaxoPluginExecutionException(final String message, final Object source) {
        super(message);
        this.src = source;
    }

    /**
     * Construct a new JaxoPluginExecutionException exception wrapping an
     * underlying Throwable and providing a message.
     *
     * @param message a message. This could be displayed in error dialogs,
     * so it should be an internationalized string.
     * @param cause the underlying cause of the Exception.
     * @param source the source of the Exception, may be null.
     */
    public JaxoPluginExecutionException(final String message, final Throwable cause,
        final Object source) {
        super(message, cause);
        this.src = source;
    }

    /**
     * Get the source of the Exception.
     *
     * @return the source of the Exception, may be null.
     */
    public Object getSource() {
        return src;
    }
}
