/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.plugin;

/**
 * A wrapper of JaxoLog for plugins.
 */
public interface JaxoPluginLogger {

    /**
     * Check if a debug message would actually be logged by the current logger.
     *
     * @return true if debug logging is enabled.
     */
    boolean isDebugEnabled();

    /**
     * Check if a info message would actually be logged by the current logger.
     *
     * @return true if info logging is enabled.
     */
    boolean isInfoEnabled();

    /**
     * Check if a warn message would actually be logged by the current logger.
     *
     * @return true if warn logging is enabled.
     */
    boolean isWarnEnabled();

    /**
     * Logs a DEBUG message.
     *
     * @param msg The log message.
     */
    void debug(String msg);

    /**
     * Logs a DEBUG exception.
     *
     * @param e An exception to log.
     */
    void debug(Exception e);

    /**
     * Logs a DEBUG message.
     *
     * @param msg The log message.
     * @param e An exception to log.
     */
    void debug(String msg, Exception e);

    /**
     * Logs a INFO message.
     *
     * @param msg The log message.
     */
    void info(String msg);

    /**
     * Logs a INFO exception.
     *
     * @param e An exception to log.
     */
    void info(Exception e);

    /**
     * Logs a INFO message.
     *
     * @param msg The log message.
     * @param e An exception to log.
     */
    void info(String msg, Exception e);

    /**
     * Logs a WARN message.
     *
     * @param msg The log message.
     */
    void warn(String msg);

    /**
     * Logs a WARN exception.
     *
     * @param e An exception to log.
     */
    void warn(Exception e);

    /**
     * Logs a WARN message.
     *
     * @param msg The log message.
     * @param e An exception to log.
     */
    void warn(String msg, Exception e);
}
