/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.util;


/** Interface for objects that need to be updated on language changes.
 * @since 2.0
 */
public interface JaxoLocalized {
    /**
     * Updates the component with the current language as set in the
     * preferences ({@link net.sf.jaxodraw.util.JaxoPrefs#PREF_LANGUAGE}).
     */
    void updateLanguage();
}
