/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.util.graphics;

import java.awt.Graphics2D;


/** Graphic2Ds that also stores JaxoDraw-specific state and can
 * perform JaxoDraw-specific painting.
 * @since 2.0
 */
public class JaxoGraphics2D extends JaxoWrapperGraphics2D {
    private boolean printing;

    /**
     * Constructor.
     * @param g The Graphics2D object.
     */
    public JaxoGraphics2D(final Graphics2D g) {
        super(g);
    }

    /**
     * If printing is active, do not paint any UI-elements or aids.
     * @return True if printing is active.
     */
    public final boolean isPrinting() {
        return printing;
    }

    /**
     * Sets whether printing is currently active.
     * @param value True if printing is active.
     */
    public void setPrinting(final boolean value) {
        printing = value;
    }
}
