/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.gui.handle;

/**
 * Test of JaxoDefaultHandle.java.
 */
public class JaxoDefaultHandleTest extends AbstractJaxoHandleTest {

    /**
     * Constructor.
     *
     * @param testName name of the test.
     */
    public JaxoDefaultHandleTest(String testName) {
        super(testName);
    }

    /**
     * Test of contains method, of class JaxoDefaultHandle.
     */
    public void testContains() {
        int handleX = 0;
        int handleY = 0;
        JaxoDefaultHandle instance = new JaxoDefaultHandle();
        assertTrue(instance.contains(handleX, handleY, 0, 0));
        assertTrue(instance.contains(handleX, handleY, 4, -4));
        assertFalse(instance.contains(handleX, handleY, 5, -4));
    }

    /** {@inheritDoc} */
    public AbstractJaxoHandle getInstance() {
        return new JaxoDefaultHandle();
    }

}
