/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.gui.handle;

/**
 * Test of JaxoRoundHandle.java.
 */
public class JaxoRoundHandleTest extends AbstractJaxoHandleTest {

    /**
     * Constructor.
     *
     * @param testName name of the test.
     */
    public JaxoRoundHandleTest(String testName) {
        super(testName);
    }

    /**
     * Test of contains method, of class JaxoRoundHandle.
     */
    public void testContains() {
        int handleX = 0;
        int handleY = 0;
        JaxoRoundHandle instance = new JaxoRoundHandle();
        assertTrue(instance.contains(handleX, handleY, 0, 0));
        assertTrue(instance.contains(handleX, handleY, 9, 0));
        assertFalse(instance.contains(handleX, handleY, 9, 9));
    }

    /** {@inheritDoc} */
    public AbstractJaxoHandle getInstance() {
        return new JaxoRoundHandle();
    }

}
