/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import net.sf.jaxodraw.util.JaxoConstants;

/**
 * Test of JaxoFileMenu.
 */
public class JaxoFileMenuTest extends AbstractMenuBarTest {
    /**
     * Constructor.
     *
     * @param testName name of the test.
     */
    public JaxoFileMenuTest(String testName) {
        super(testName);
    }

    /**
     * Test Recent File menu.
     */
    public void testRecent() {
        // how to assert changes in RecentMenu?
        firePropertyChange("Jaxo.recentFile", null, "newfile");
        firePropertyChange("Jaxo.recentFile", "newfile", null);
    }

    /**
     * Test Quit menu item.
     */
    public void testQuit() {
        assertAction(JaxoConstants.QUIT);
    }

    /**
     * Test Print menu item.
     */
    public void testPrint() {
        assertAction(JaxoConstants.PRINT);
    }

    /**
     * Test Export menu item.
     */
    public void testExport() {
        assertAction(JaxoConstants.EXPORT);
    }

    /**
     * Test Import menu item.
     */
    public void testImport() {
        assertAction(JaxoConstants.IMPORT);
    }

    /**
     * Test Rename menu item.
     */
    public void testRename() {
        assertAction(JaxoConstants.RENAME_TAB);
    }

    /**
     * Test SaveA menu item.
     */
    public void testSaveAs() {
        assertAction(JaxoConstants.SAVE_AS);
    }

    /**
     * Test Save menu item.
     */
    public void testSave() {
        assertAction(JaxoConstants.SAVE);
    }

    /**
     * Test Close menu item.
     */
    public void testClose() {
        assertAction(JaxoConstants.CLOSE);
    }

    /**
     * Test Open menu item.
     */
    public void testOpen() {
        assertAction(JaxoConstants.OPEN);
    }

    /** {@inheritDoc} */
    public void assertSetup() {
        // nop
    }

    /** {@inheritDoc} */
    public void assertLanguage() {
        // nop
    }



}
