/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import net.sf.jaxodraw.util.JaxoConstants;

/**
 * Test of JaxoHelpMenu.
 */
public class JaxoHelpMenuTest extends AbstractMenuBarTest {
    /**
     * Constructor.
     *
     * @param testName name of the test.
     */
    public JaxoHelpMenuTest(String testName) {
        super(testName);
    }

    /**
     * Test UserGuide menu item.
     */
    public void testUserGuide() {
        assertAction(JaxoConstants.USR_GUIDE);
    }

    /**
     * Test SysInfo menu item.
     */
    public void testSysinfo() {
        assertAction(JaxoConstants.SYS_INFO);
    }

    /**
     * Test About menu item.
     */
    public void testAbout() {
        assertAction(JaxoConstants.ABOUT);
    }

    /**
     * Test MacReadme menu item.
     */
    public void testMacReadme() {
        assertAction(JaxoConstants.MAC_README);
    }

    /** {@inheritDoc} */
    public void assertSetup() {
        // nop
    }

    /** {@inheritDoc} */
    public void assertLanguage() {
        // nop
    }

}
