/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;

/**
 * Test of JaxoOptionsMenu.
 */
public class JaxoOptionsMenuTest extends AbstractMenuBarTest {
    /**
     * Constructor.
     *
     * @param testName name of the test.
     */
    public JaxoOptionsMenuTest(String testName) {
        super(testName);
    }

    /**
     * Test vertex menu.
     */
    public void testVertexMenu() {
        assertSelected(JaxoConstants.VERTEXT1);

        firePropertyChange("Jaxo.vertexType",
                new Integer(JaxoConstants.VERTEXT1),
                new Integer(JaxoConstants.VERTEXT2));
        assertSelected(JaxoConstants.VERTEXT2);

        firePropertyChange("Jaxo.vertexType",
                new Integer(JaxoConstants.VERTEXT2),
                new Integer(JaxoConstants.VERTEXT3));
        assertSelected(JaxoConstants.VERTEXT3);

        firePropertyChange("Jaxo.vertexType",
                new Integer(JaxoConstants.VERTEXT3),
                new Integer(JaxoConstants.VERTEXT4));
        assertSelected(JaxoConstants.VERTEXT4);

        firePropertyChange("Jaxo.vertexType",
                new Integer(JaxoConstants.VERTEXT4),
                new Integer(JaxoConstants.VERTEXT5));
        assertSelected(JaxoConstants.VERTEXT5);

        firePropertyChange("Jaxo.vertexType",
                new Integer(JaxoConstants.VERTEXT5),
                new Integer(JaxoConstants.VERTEXT6));
        assertSelected(JaxoConstants.VERTEXT6);

        firePropertyChange("Jaxo.vertexType",
                new Integer(JaxoConstants.VERTEXT6),
                new Integer(JaxoConstants.VERTEXT1));
        assertSelected(JaxoConstants.VERTEXT1);

        firePropertyChange("Jaxo.vertexType",
                new Integer(JaxoConstants.VERTEXT1),
                new Integer(JaxoConstants.BLOB));
        assertSelected(JaxoConstants.VERTEXT1);

    }

    /**
     * Test language menu.
     */
    public void testLanguageMenu() {
        firePropertyChange("Jaxo.language", null, JaxoLanguage.ENGLISH);
        assertSelected(JaxoConstants.ENGLISH);
        firePropertyChange("Jaxo.language", null, JaxoLanguage.FRENCH);
        assertSelected(JaxoConstants.FRENCH);
        firePropertyChange("Jaxo.language", null, JaxoLanguage.GERMAN);
        assertSelected(JaxoConstants.GERMAN);
        firePropertyChange("Jaxo.language", null, JaxoLanguage.ITALIAN);
        assertSelected(JaxoConstants.ITALIAN);
        firePropertyChange("Jaxo.language", null, JaxoLanguage.SPANISH);
        assertSelected(JaxoConstants.SPANISH);
        firePropertyChange("Jaxo.language", null, "stoasteirisch");
        assertSelected(JaxoConstants.SPANISH);
    }

    /**
     * Test default mode menu.
     */
    public void testDefaultMenu() {
        firePropertyChange("Jaxo.defaultAction", null, new Integer(JaxoConstants.DEF_BOX));
        assertSelected(JaxoConstants.DEF_BOX);
        firePropertyChange("Jaxo.defaultAction", null, new Integer(JaxoConstants.ARROW));
        assertSelected(JaxoConstants.DEF_NONE);
    }

    /**
     * Test Preferences menu item.
     */
    public void testPrefs() {
        assertAction(JaxoConstants.PREFERENCES);
    }

    /**
     * Test PluginManager menu item.
     */
    public void testPluginManager() {
        assertAction(JaxoConstants.PLUGINS);
    }

    /**
     * Test Snap On/Off menu item.
     */
    public void testSnap() {
        assertChecked(JaxoConstants.SNAP_ONOFF, "Jaxo.snap");
    }

    /**
     * Test Grid On/Off menu item.
     */
    public void testGridOn() {
        assertChecked(JaxoConstants.GRID_ONOFF, "Jaxo.gridOn");
    }

    /**
     * Test Arrow menu item.
     */
    public void testArrow() {
        assertChecked(JaxoConstants.ARROW, "Jaxo.withArrow");
    }

    /**
     * Test Antialias menu item.
     */
    public void testAntialias() {
        assertChecked(JaxoConstants.ANTIALIAS, "Jaxo.antialiasEnabled");
    }

    /**
     * Test GridBar menu item.
     */
    public void testGridBar() {
        assertChecked(JaxoConstants.GRIDBAR, "Jaxo.gridBarVisible");
    }

    /**
     * Test StatusBar menu item.
     */
    public void testStatusBar() {
        assertChecked(JaxoConstants.STATUSBAR, "Jaxo.statusBarVisible");
    }

    /**
     * Test ToolBar menu item.
     */
    public void testToolBar() {
        assertChecked(JaxoConstants.TOOLBAR, "Jaxo.toolBarVisible");
    }

    /**
     * Test LooknFeel menu item.
     */
    public void testLooknFeel() {
        assertAction(JaxoConstants.LOOKNFEEL);
    }

    /**
     * Test Latex Package menu item.
     */
    public void testPackage() {
        assertAction(JaxoConstants.PACKAGE);
    }

    /**
     * Test Describe menu item.
     */
    public void testDescribe() {
        assertAction(JaxoConstants.DESCRIBE);
    }

    /**
     * Test MoveGraph menu item.
     */
    public void testMoveGraph() {
        assertAction(JaxoConstants.MOVE_GRAPH);
    }

    /** {@inheritDoc} */
    public void assertSetup() {
        // nop
    }

    /** {@inheritDoc} */
    public void assertLanguage() {
        // nop
    }
}
