/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Point;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;

import net.sf.jaxodraw.object.arc.JaxoFArc;
import net.sf.jaxodraw.JaxoTestUtils;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class Jaxo3PointsEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public Jaxo3PointsEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        Jaxo3PointsEditPanel panel = new Jaxo3PointsEditPanel();
        JSpinner spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx");
        JSpinner spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy");
        JSpinner spx2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx2");
        JSpinner spy2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy2");
        JSpinner spx3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx3");
        JSpinner spy3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy3");
        assertNotNull("No x1 spinner found!", spx);
        assertNotNull("No y1 spinner found!", spy);
        assertNotNull("No x2 spinner found!", spx2);
        assertNotNull("No y2 spinner found!", spy2);
        assertNotNull("No x3 spinner found!", spx3);
        assertNotNull("No y3 spinner found!", spy3);
        SpinnerNumberModel modelx = (SpinnerNumberModel) spx.getModel();
        SpinnerNumberModel modely = (SpinnerNumberModel) spy.getModel();
        SpinnerNumberModel modelx2 = (SpinnerNumberModel) spx2.getModel();
        SpinnerNumberModel modely2 = (SpinnerNumberModel) spy2.getModel();
        SpinnerNumberModel modelx3 = (SpinnerNumberModel) spx3.getModel();
        SpinnerNumberModel modely3 = (SpinnerNumberModel) spy3.getModel();
        int value = modelx.getNumber().intValue();
        assertEquals(0, value);
        value = modely.getNumber().intValue();
        assertEquals(0, value);
        value = modelx2.getNumber().intValue();
        assertEquals(0, value);
        value = modely2.getNumber().intValue();
        assertEquals(0, value);
        value = modelx3.getNumber().intValue();
        assertEquals(0, value);
        value = modely3.getNumber().intValue();
        assertEquals(0, value);

        Point p1 = new Point(20, 30);
        Point p2 = new Point(40, 50);
        Point p3 = new Point(60, 70);

        panel = new Jaxo3PointsEditPanel(new Point[] {p1, p2, p3});
        spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx");
        spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy");
        spx2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx2");
        spy2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy2");
        spx3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx3");
        spy3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy3");
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        modelx2 = (SpinnerNumberModel) spx2.getModel();
        modely2 = (SpinnerNumberModel) spy2.getModel();
        modelx3 = (SpinnerNumberModel) spx3.getModel();
        modely3 = (SpinnerNumberModel) spy3.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(20, value);
        value = modely.getNumber().intValue();
        assertEquals(30, value);
        value = modelx2.getNumber().intValue();
        assertEquals(40, value);
        value = modely2.getNumber().intValue();
        assertEquals(50, value);
        value = modelx3.getNumber().intValue();
        assertEquals(60, value);
        value = modely3.getNumber().intValue();
        assertEquals(70, value);

        JaxoFArc arc = new JaxoFArc();
        arc.setLocation(10, 50, 20, 60, 30, 90);
        p1.setLocation(arc.getX(), arc.getY());
        p2.setLocation(arc.getX2(), arc.getY2());
        p3.setLocation(arc.getX3(), arc.getY3());
        panel = new Jaxo3PointsEditPanel(new Point[] {p1, p2, p3});

        spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx");
        spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy");
        spx2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx2");
        spy2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy2");
        spx3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx3");
        spy3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy3");
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        modelx2 = (SpinnerNumberModel) spx2.getModel();
        modely2 = (SpinnerNumberModel) spy2.getModel();
        modelx3 = (SpinnerNumberModel) spx3.getModel();
        modely3 = (SpinnerNumberModel) spy3.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(10, value);
        value = modely.getNumber().intValue();
        assertEquals(50, value);
        value = modelx2.getNumber().intValue();
        assertEquals(20, value);
        value = modely2.getNumber().intValue();
        assertEquals(60, value);
        value = modelx3.getNumber().intValue();
        assertEquals(30, value);
        value = modely3.getNumber().intValue();
        assertEquals(90, value);

        ChangeListener[] listeners = spx.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spx2.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy2.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spx3.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy3.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(null);
        listeners = spx.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spx2.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy2.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spx3.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy3.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(arc));
        listeners = spx.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spx2.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spy2.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spx3.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spy3.getChangeListeners();
        assertEquals(2, listeners.length);

        spx.setValue(new Integer(50));
        spy.setValue(new Integer(150));
        spx2.setValue(new Integer(250));
        spy2.setValue(new Integer(350));
        spx3.setValue(new Integer(77));
        spy3.setValue(new Integer(33));
        assertEquals(50, arc.getX());
        assertEquals(150, arc.getY());
        assertEquals(250, arc.getX2());
        assertEquals(350, arc.getY2());
        assertEquals(77, arc.getX3());
        assertEquals(33, arc.getY3());

    }

}
