/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Point;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;

import net.sf.jaxodraw.object.bezier.JaxoFBezier;
import net.sf.jaxodraw.JaxoTestUtils;


/** Tests methods in JaxoEditPanel using JaxoFBezier as instance. */
public class Jaxo4PointsEditPanelTest extends TestCase {

    private JSpinner spx, spy, spx2, spy2, spx3, spy3, spx4, spy4;
    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public Jaxo4PointsEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        Jaxo4PointsEditPanel panel = new Jaxo4PointsEditPanel();
        setupSpinners(panel);

        assertNotNull("No x1 spinner found!", spx);
        assertNotNull("No y1 spinner found!", spy);
        assertNotNull("No x2 spinner found!", spx2);
        assertNotNull("No y2 spinner found!", spy2);
        assertNotNull("No x3 spinner found!", spx3);
        assertNotNull("No y3 spinner found!", spy3);
        assertNotNull("No x4 spinner found!", spx4);
        assertNotNull("No y4 spinner found!", spy4);
        SpinnerNumberModel modelx = (SpinnerNumberModel) spx.getModel();
        SpinnerNumberModel modely = (SpinnerNumberModel) spy.getModel();
        SpinnerNumberModel modelx2 = (SpinnerNumberModel) spx2.getModel();
        SpinnerNumberModel modely2 = (SpinnerNumberModel) spy2.getModel();
        SpinnerNumberModel modelx3 = (SpinnerNumberModel) spx3.getModel();
        SpinnerNumberModel modely3 = (SpinnerNumberModel) spy3.getModel();
        SpinnerNumberModel modelx4 = (SpinnerNumberModel) spx4.getModel();
        SpinnerNumberModel modely4 = (SpinnerNumberModel) spy4.getModel();
        int value = modelx.getNumber().intValue();
        assertEquals(0, value);
        value = modely.getNumber().intValue();
        assertEquals(0, value);
        value = modelx2.getNumber().intValue();
        assertEquals(0, value);
        value = modely2.getNumber().intValue();
        assertEquals(0, value);
        value = modelx3.getNumber().intValue();
        assertEquals(0, value);
        value = modely3.getNumber().intValue();
        assertEquals(0, value);
        value = modelx4.getNumber().intValue();
        assertEquals(0, value);
        value = modely4.getNumber().intValue();
        assertEquals(0, value);

        Point p1 = new Point(20, 30);
        Point p2 = new Point(40, 50);
        Point p3 = new Point(60, 70);
        Point p4 = new Point(80, 90);

        panel = new Jaxo4PointsEditPanel(new Point[] {p1, p2, p3, p4});
        setupSpinners(panel);
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        modelx2 = (SpinnerNumberModel) spx2.getModel();
        modely2 = (SpinnerNumberModel) spy2.getModel();
        modelx3 = (SpinnerNumberModel) spx3.getModel();
        modely3 = (SpinnerNumberModel) spy3.getModel();
        modelx4 = (SpinnerNumberModel) spx4.getModel();
        modely4 = (SpinnerNumberModel) spy4.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(20, value);
        value = modely.getNumber().intValue();
        assertEquals(30, value);
        value = modelx2.getNumber().intValue();
        assertEquals(40, value);
        value = modely2.getNumber().intValue();
        assertEquals(50, value);
        value = modelx3.getNumber().intValue();
        assertEquals(60, value);
        value = modely3.getNumber().intValue();
        assertEquals(70, value);
        value = modelx4.getNumber().intValue();
        assertEquals(80, value);
        value = modely4.getNumber().intValue();
        assertEquals(90, value);

        JaxoFBezier bezier = new JaxoFBezier();
        bezier.setLocation(10, 50, 20, 60, 30, 90, 40, 70);
        p1.setLocation(bezier.getX(), bezier.getY());
        p2.setLocation(bezier.getX2(), bezier.getY2());
        p3.setLocation(bezier.getX3(), bezier.getY3());
        p4.setLocation(bezier.getX4(), bezier.getY4());
        panel = new Jaxo4PointsEditPanel(new Point[] {p1, p2, p3, p4});

        setupSpinners(panel);
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        modelx2 = (SpinnerNumberModel) spx2.getModel();
        modely2 = (SpinnerNumberModel) spy2.getModel();
        modelx3 = (SpinnerNumberModel) spx3.getModel();
        modely3 = (SpinnerNumberModel) spy3.getModel();
        modelx4 = (SpinnerNumberModel) spx4.getModel();
        modely4 = (SpinnerNumberModel) spy4.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(10, value);
        value = modely.getNumber().intValue();
        assertEquals(50, value);
        value = modelx2.getNumber().intValue();
        assertEquals(20, value);
        value = modely2.getNumber().intValue();
        assertEquals(60, value);
        value = modelx3.getNumber().intValue();
        assertEquals(30, value);
        value = modely3.getNumber().intValue();
        assertEquals(90, value);
        value = modelx4.getNumber().intValue();
        assertEquals(40, value);
        value = modely4.getNumber().intValue();
        assertEquals(70, value);

        assertListenerLength(1);

        panel.addEditPanelListener(null);
        assertListenerLength(1);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(bezier));
        assertListenerLength(2);

        spx.setValue(new Integer(50));
        spy.setValue(new Integer(150));
        spx2.setValue(new Integer(250));
        spy2.setValue(new Integer(350));
        spx3.setValue(new Integer(77));
        spy3.setValue(new Integer(33));
        spx4.setValue(new Integer(5));
        spy4.setValue(new Integer(0));
        assertEquals(50, bezier.getX());
        assertEquals(150, bezier.getY());
        assertEquals(250, bezier.getX2());
        assertEquals(350, bezier.getY2());
        assertEquals(77, bezier.getX3());
        assertEquals(33, bezier.getY3());
        assertEquals(5, bezier.getX4());
        assertEquals(0, bezier.getY4());

    }

    private void assertListenerLength(int length) {
        ChangeListener[] listeners = spx.getChangeListeners();
        assertEquals(length, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(length, listeners.length);
        listeners = spx2.getChangeListeners();
        assertEquals(length, listeners.length);
        listeners = spy2.getChangeListeners();
        assertEquals(length, listeners.length);
        listeners = spx3.getChangeListeners();
        assertEquals(length, listeners.length);
        listeners = spy3.getChangeListeners();
        assertEquals(length, listeners.length);
        listeners = spx4.getChangeListeners();
        assertEquals(length, listeners.length);
        listeners = spy4.getChangeListeners();
        assertEquals(length, listeners.length);
    }

    private void setupSpinners(Jaxo4PointsEditPanel panel) {
        spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx");
        spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy");
        spx2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx2");
        spy2 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy2");
        spx3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx3");
        spy3 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy3");
        spx4 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx4");
        spy4 = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy4");
    }
}
