/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.arc.JaxoFArc;
import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.object.arc.JaxoGArc;
import net.sf.jaxodraw.JaxoTestUtils;

import java.awt.event.ItemListener;

import javax.swing.JCheckBox;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoArrowEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoArrowEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoArrowEditPanel panel = new JaxoArrowEditPanel();
        JCheckBox arrowcb = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "arrow");
        JCheckBox flipcb = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "flip");
        assertNotNull("No arrow checkbox found!", arrowcb);
        assertNotNull("No flip checkbox found!", flipcb);
        assertTrue(arrowcb.isSelected());
        assertFalse(flipcb.isSelected());


        panel = new JaxoArrowEditPanel(true, true, 0.5f);
        arrowcb = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "arrow");
        flipcb = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "flip");
        assertNotNull("No arrow checkbox found!", arrowcb);
        assertNotNull("No flip checkbox found!", flipcb);
        assertTrue(arrowcb.isSelected());
        assertTrue(flipcb.isSelected());

        JaxoFLine line = new JaxoFLine();
        line.setPaintArrow(true);
        line.setFlip(true);
        line.setArrowPosition(0.5f);

        panel = new JaxoArrowEditPanel(
                line.isPaintArrow(), line.isFlip(), line.getArrowPosition());
        arrowcb = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "arrow");
        flipcb = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "flip");
        assertTrue(arrowcb.isSelected());
        assertTrue(flipcb.isSelected());

        ItemListener[] listeners = arrowcb.getItemListeners();
        ItemListener[] fliplisteners = flipcb.getItemListeners();
        assertEquals(1, listeners.length);
        assertEquals(0, fliplisteners.length);
        panel.addEditPanelListener(null);
        listeners = arrowcb.getItemListeners();
        fliplisteners = flipcb.getItemListeners();
        assertEquals(1, listeners.length);
        assertEquals(0, fliplisteners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = arrowcb.getItemListeners();
        fliplisteners = flipcb.getItemListeners();
        assertEquals(2, listeners.length);
        assertEquals(1, fliplisteners.length);

        arrowcb.setSelected(false);
        assertFalse(line.isPaintArrow());
        arrowcb.setSelected(true);
        assertTrue(line.isPaintArrow());
        flipcb.setSelected(false);
        assertFalse(line.isFlip());
        flipcb.setSelected(true);
        assertTrue(line.isFlip());

        JaxoFArc arc = new JaxoFArc();
        arc.setPaintArrow(false);
        arc.setFlip(true);
        arc.setArrowPosition(0.5f);

        panel = new JaxoArrowEditPanel(
                arc.isPaintArrow(), arc.isFlip(), arc.getArrowPosition());
        panel.addEditPanelListener(new JaxoOptionsPanelListener(arc));

        JaxoGArc garc = new JaxoGArc();
        garc.setPaintArrow(true);
        garc.setFlip(true);
        garc.setArrowPosition(0.5f);

        panel = new JaxoArrowEditPanel(
                garc.isPaintArrow(), garc.isFlip(), garc.getArrowPosition());
        arrowcb = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "arrow");
        panel.addEditPanelListener(new JaxoOptionsPanelListener(garc));
        arrowcb.setSelected(false);
        assertFalse(garc.isPaintArrow());
    }

}
