/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.JaxoTestUtils;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoCenterSizeEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoCenterSizeEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoCenterSizeEditPanel panel = new JaxoCenterSizeEditPanel();
        JSpinner spxin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        JSpinner spyin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        JSpinner spwidth = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spwidth");
        JSpinner spheight = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spheight");
        assertNotNull("No x1 spinner found!", spxin);
        assertNotNull("No y1 spinner found!", spyin);
        assertNotNull("No width spinner found!", spwidth);
        assertNotNull("No height spinner found!", spheight);
        SpinnerNumberModel modelx = (SpinnerNumberModel) spxin.getModel();
        SpinnerNumberModel modely = (SpinnerNumberModel) spyin.getModel();
        SpinnerNumberModel modelxfin = (SpinnerNumberModel) spwidth.getModel();
        SpinnerNumberModel modelyfin = (SpinnerNumberModel) spheight.getModel();
        int value = modelx.getNumber().intValue();
        assertEquals(200, value);
        value = modely.getNumber().intValue();
        assertEquals(200, value);
        value = modelxfin.getNumber().intValue();
        assertEquals(20, value);
        value = modelyfin.getNumber().intValue();
        assertEquals(20, value);

        panel = new JaxoCenterSizeEditPanel(20, 30, 40, 50);
        spxin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        spyin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        spwidth = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spwidth");
        spheight = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spheight");
        modelx = (SpinnerNumberModel) spxin.getModel();
        modely = (SpinnerNumberModel) spyin.getModel();
        modelxfin = (SpinnerNumberModel) spwidth.getModel();
        modelyfin = (SpinnerNumberModel) spheight.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(20, value);
        value = modely.getNumber().intValue();
        assertEquals(30, value);
        value = modelxfin.getNumber().intValue();
        assertEquals(40, value);
        value = modelyfin.getNumber().intValue();
        assertEquals(50, value);

        JaxoFLine line = new JaxoFLine();
        line.setLocation(10, 50, 20, 60);
        panel = new JaxoCenterSizeEditPanel(
                line.getX(), line.getY(), line.getWidth(), line.getHeight());

        spxin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        spyin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        spwidth = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spwidth");
        spheight = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spheight");
        modelx = (SpinnerNumberModel) spxin.getModel();
        modely = (SpinnerNumberModel) spyin.getModel();
        modelxfin = (SpinnerNumberModel) spwidth.getModel();
        modelyfin = (SpinnerNumberModel) spheight.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(10, value);
        value = modely.getNumber().intValue();
        assertEquals(50, value);
        value = modelxfin.getNumber().intValue();
        assertEquals(10, value);
        value = modelyfin.getNumber().intValue();
        assertEquals(10, value);

        ChangeListener[] listeners = spxin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spyin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spwidth.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spheight.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(null);
        listeners = spxin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spyin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spwidth.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spheight.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = spxin.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spyin.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spwidth.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spheight.getChangeListeners();
        assertEquals(2, listeners.length);

        spxin.setValue(new Integer(50));
        spyin.setValue(new Integer(150));
        spwidth.setValue(new Integer(25));
        spheight.setValue(new Integer(35));
        assertEquals(50, line.getX());
        assertEquals(150, line.getY());
        assertEquals(75, line.getX2());
        assertEquals(185, line.getY2());

    }

}
