/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.JaxoTestUtils;

import java.awt.event.ItemListener;

import javax.swing.JComboBox;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoLatexFontSizePanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoLatexFontSizePanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoLatexFontSizePanel panel = new JaxoLatexFontSizePanel();
        JComboBox cbox = (JComboBox) JaxoTestUtils.getChildNamed(panel, "latexfontsize");
        assertNotNull("No latexfontsize combobox found!", cbox);
        assertEquals(4, cbox.getSelectedIndex());


        JaxoLatexText text = new JaxoLatexText();
        text.setLatexTextSize(JaxoLatexText.SMALL);

        panel = new JaxoLatexFontSizePanel(text.getLatexTextSize());
        cbox = (JComboBox) JaxoTestUtils.getChildNamed(panel, "latexfontsize");
        assertEquals(3, cbox.getSelectedIndex());

        ItemListener[] listeners = cbox.getItemListeners();
        assertTrue(listeners.length > 0);
        // this passes on Windows and Linux, but fails on Mac
        // compile once, run everywhere,... my foot
        //assertEquals(1, listeners.length);
        panel.addEditPanelListener(null);
        listeners = cbox.getItemListeners();
        //assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(text));
        listeners = cbox.getItemListeners();
        //assertEquals(2, listeners.length);

        cbox.setSelectedIndex(3);
        assertEquals(3, text.getLatexTextSize());

    }

}
