/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.JaxoTestUtils;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoPositionEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoPositionEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoPositionEditPanel panel = new JaxoPositionEditPanel();
        JSpinner spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        JSpinner spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        assertNotNull("No x1 spinner found!", spx);
        assertNotNull("No y1 spinner found!", spy);
        SpinnerNumberModel modelx = (SpinnerNumberModel) spx.getModel();
        SpinnerNumberModel modely = (SpinnerNumberModel) spy.getModel();
        int value = modelx.getNumber().intValue();
        assertEquals(100, value);
        value = modely.getNumber().intValue();
        assertEquals(100, value);

        panel = new JaxoPositionEditPanel(20, 30);
        spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(20, value);
        value = modely.getNumber().intValue();
        assertEquals(30, value);

        JaxoLatexText text = new JaxoLatexText();
        text.setLocation(10, 50);
        panel = new JaxoPositionEditPanel(text.getX(), text.getY());

        spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(10, value);
        value = modely.getNumber().intValue();
        assertEquals(50, value);

        ChangeListener[] listeners = spx.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(null);
        listeners = spx.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(text));
        listeners = spx.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(2, listeners.length);

        spx.setValue(new Integer(50));
        spy.setValue(new Integer(150));
        assertEquals(50, text.getX());
        assertEquals(150, text.getY());

    }

}
